% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_stochasticvirus.r
\name{simulate_stochasticvirus}
\alias{simulate_stochasticvirus}
\title{Stochastic simulation of a compartmental acute virus infection model}
\usage{
simulate_stochasticvirus(U0 = 10000, I0 = 0, V0 = 5, tmax = 30,
  n = 0, dU = 0, b = 1e-04, dI = 1, p = 10, dV = 2,
  rngseed = 100)
}
\arguments{
\item{U0}{initial number of target cells. Needs to be an integer.}

\item{I0}{initial number of wild-type infected cells. Needs to be an integer.}

\item{V0}{initial number of resistant virus. Needs to be an integer.}

\item{tmax}{maximum simulation time, units depend on choice of units for your
parameters}

\item{n}{rate of uninfected cell production}

\item{dU}{rate of uninfected cell removal}

\item{b}{level/rate of infection of cells}

\item{dI}{rate of infected cell death}

\item{p}{virus production rate}

\item{dV}{virus removal rate}

\item{rngseed}{seed for random number generator to allow reproducibility}
}
\value{
A list. The list has only one element called ts.
ts contains the time-series of the simulation.
The 1st column of ts is Time, the other columns are the model variables.
}
\description{
Simulation of a stochastic model with the following compartments:
Uninfected target cells (U), Infected cells (I), virus (V).
}
\details{
A compartmental ID model with several states/compartments
is simulated as a stochastic model using the adaptive tau algorithm as implemented by ssa.adaptivetau()
in the adaptivetau package. See the manual of this package for more details.
The function returns the time series of the simulated disease as output matrix,
with one column per compartment/variable. The first column is time.
}
\section{Warning}{

This function does not perform any error checking. So if you try to do
something nonsensical (e.g. have I0 > PopSize or any negative values or fractions > 1),
the code will likely abort with an error message.
}

\examples{
# To run the simulation with default parameters just call the function:
result <- simulate_stochasticvirus()
# To choose parameter values other than the standard one, specify them, like such:
result <- simulate_stochasticvirus(tmax = 20, dI = 0.5)
# You should then use the simulation result returned from the function, like this:
plot(result$ts[,"Time"],result$ts[,"V"],xlab='Time',ylab='Virus',type='l')
}
\references{
See the manual for the adaptivetau package for details on the algorithm.
            See the app corresponding to this function in DSAIDE for more details on the model.
}
\author{
Andreas Handel
}
