% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_fludrug_fit.R
\name{simulate_fludrug_fit}
\alias{simulate_fludrug_fit}
\title{Fitting a simple viral infection model with 2 types of drug mechanisms to influenza data}
\usage{
simulate_fludrug_fit(
  U = 1e+05,
  I = 0,
  V = 1,
  dI = 2,
  dV = 4,
  b = 0.01,
  blow = 1e-05,
  bhigh = 10,
  p = 0.01,
  plow = 1e-05,
  phigh = 10,
  g = 1,
  glow = 0,
  ghigh = 1000,
  e = 0.5,
  fitmodel = 1,
  iter = 500
)
}
\arguments{
\item{U}{: initial number of uninfected target cells : numeric}

\item{I}{: initial number of infected target cells : numeric}

\item{V}{: initial number of infectious virions : numeric}

\item{dI}{: rate at which infected cells die : numeric}

\item{dV}{: rate at which infectious virus is cleared : numeric}

\item{b}{: rate at which virus infects cells : numeric}

\item{blow}{: lower bound for infection rate : numeric}

\item{bhigh}{: upper bound for infection rate : numeric}

\item{p}{: rate at which infected cells produce virus : numeric}

\item{plow}{: lower bound for virus production rate : numeric}

\item{phigh}{: upper bound for virus production rate : numeric}

\item{g}{: unit conversion factor : numeric}

\item{glow}{: lower bound for unit conversion factor : numeric}

\item{ghigh}{: upper bound for unit conversion factor : numeric}

\item{e}{: drug efficacy (between 0-1) : numeric}

\item{fitmodel}{: fitting model 1 or 2 : numeric}

\item{iter}{: max number of steps to be taken by optimizer : numeric}
}
\value{
The function returns a list containing the best fit timeseries,
the best fit parameters, the data and the AICc for the model.
}
\description{
This function fits the simulate_virusandtx_ode model,
which is a compartment model
using a set of ordinary differential equations.
The model describes a simple viral infection system in the presence of drug treatment.
The user provides initial conditions and parameter values for the system.
The function simulates the ODE using an ODE solver from the deSolve package.
}
\details{
A simple compartmental ODE models describing an acute viral infection with drug treatment
mechanism/model 1 assumes that drug treatment reduces rate of new virus production.
mechanism/model 2 assumes  that drug treatment reduces rate of new cell infection.
}
\section{Warning}{
 This function does not perform any error checking. So if
  you try to do something nonsensical (e.g. specify negative parameter or starting values),
  the code will likely abort with an error message.
}

\examples{
# To run the code with default parameters just call the function:
\dontrun{result <- simulate_fludrug_fit()}
# To apply different settings, provide them to the simulator function, like such:
result <- simulate_fludrug_fit(iter = 5, fitmodel = 1)
}
\seealso{
See the Shiny app documentation corresponding to this
function for more details on this model.
}
\author{
Andreas Handel
}
