#' @title Doubly Truncated Data Analysis, Cumulative Incidence Functions
#'
#'
#' @description Nonparametric estimator of the cumulative incidences of competing risks under double truncation. The estimator generalizes the Efron-Petrosian NPMLE (Non-Parametric Maximun Likelihood Estimator) to the competing risks setting.
#'
#'
#' @details
#' \itemize{
#' \item{Package: ‘DTDA.cif’}
#' \item{Version: 1.0}
#' \item{Maintainer: José Carlos Soage González \email{jsoage@@uvigo.es}}
#' \item{License: GPL-2}
#' }
#'
#' @return
#' \itemize{
#' \item{‘\link{DTDAcif}’}
#' \item{‘\link{plot.DTDAcif}’}
#' \item{‘\link{summary.DTDAcif}’}
#' }
#'
#' @author
#' \itemize{
#' \item{de Uña-Álvarez, Jacobo.}
#' \item{Soage González, José Carlos.}
#' \item{Maintainer: José Carlos Soage González. \email{jsoage@@uvigo.es}}
#' }
#'
#'
#'
#' @section Acknowledgements:
#' \itemize{
#' \item{Jacobo de Uña-Álvarez was supported by Grant MTM2017-89422-P (MINECO/AEI/FEDER, UE).}
#' \item{José Carlos Soage was supported
#'  by Grupos de Referencia Competitiva, Consolidación y Estructuración de
#'  Unidades de Investigación Competitivas del SUG, Cons. de Cultura,
#'  Educación e OU, Xunta de Galicia (GRC ED431C 2016/040).}
#' }
#'
#' @references
#' \itemize{
#' \item{de Uña-Álvarez, J. (2019). Nonparametric estimation of the cumulative incidences of competing risks under double truncation. Preprint.}
#' \item{Efron, B. and Petrosian, V. (1999). Nonparametric methods for doubly truncated data. Journal of the American Statistical Association 94, 824-834.}
#' }
#'
#'
"_PACKAGE"
#> [1] "_PACKAGE"
