% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClassDTSg.R
\docType{class}
\name{DTSg}
\alias{DTSg}
\alias{new}
\title{DTSg class}
\usage{
new(Class, values, ID = "", parameter = "", unit = "", variant = "",
  aggregated = FALSE, fast = FALSE, swallow = FALSE, na.status =
  c("explicit", "implicit", "undecided"))
}
\arguments{
\item{Class}{A character string. Must be \code{"DTSg"} in order to create a \code{DTSg}
object. Otherwise a different object may or may not be created (S4
constructor only).}

\item{values}{A \code{\link{data.frame}} or object inherited from class \code{\link{data.frame}},
e.g. \code{\link[data.table:data.table]{data.table::data.table}}. Its first column must be of class
\code{\link{POSIXct}} or coercible to it. It serves as the object's time index and is
renamed to \emph{.dateTime.}}

\item{ID}{A character string specifying the ID (name) of the time series data
object.}

\item{parameter}{A character string specifying the parameter name of the time
series data.}

\item{unit}{A character string specifying the unit of the time series data.}

\item{variant}{A character string specifying further metadata of the time
series, for instance, \code{"min"} to point out that it is a time series of
lower bound measurements.}

\item{aggregated}{A logical specifying how the timestamps of the series have
to be interpreted: as snap-shots (\code{FALSE}) or as periods between subsequent
timestamps (\code{TRUE}).}

\item{fast}{A logical specifying if all rows (\code{FALSE}) or only the first 1000
rows (\code{TRUE}) shall be used to check the object's integrity and for the
automatic detection of the time series' periodicity.}

\item{swallow}{A logical specifying if the object provided through the
\code{values} argument shall be \dQuote{swallowed} by the \code{DTSg} object, i.e. no
copy of the data shall be made. This is generally more resource efficient,
but only works when the provided object is a \code{\link[data.table:data.table]{data.table::data.table}}. Be
warned, however, that when the creation of the \code{DTSg} object fails for some
reason, the first column of the provided \code{\link[data.table:data.table]{data.table::data.table}} might
have been coerced to \code{\link{POSIXct}} and keyed (see \code{\link[data.table:setkey]{data.table::setkey}} for
further information). Furthermore, all references to the \dQuote{swallowed}
\code{\link[data.table:data.table]{data.table::data.table}} in the global (and only the global) environment
are removed upon the successful creation of the \code{DTSg} object.}

\item{na.status}{A character string. Either \code{"explicit"}, which makes missing
timestamps explicit according to the recognised periodicity, or
\code{"implicit"}, which removes timestamps with missing values on all value
columns, or \code{"undecided"} for no such action. Please note that \code{DTSg}
objects work best with explicitly missing values.}
}
\value{
Returns a \code{DTSg} object.
}
\description{
The \code{DTSg} class is the working horse of the package. It is an
\code{\link[R6:R6Class]{R6::R6Class}} and offers an S3 interface in addition to its native R6
interface. In the usage sections of the documentation, unfortunately, only
the usage of the S3 methods are displayed, however, the examples always show
both ways of calling the respective method. Generally, they are very similar
anyway. While the R6 interface always has the object first and the method is
then selected with the help of the \code{$} operator, for instance, \code{x$cols()},
the S3 interface always has the method first and then the object as its first
argument, for instance, \code{cols(x)}. An exception is the \code{new} method. It is
not an S3 method, but an abused S4 constructor with the character string
\code{"DTSg"} as its first argument. Regarding the R6 interface, the \code{DTSg} class
generator has to be used to access the \code{new} method with the help of the \code{$}
operator.
}
\note{
Due to the \code{\link{POSIXct}} nature of the \emph{.dateTime} column, the same sub-second
accuracy, issues and limitations apply to \code{DTSg} objects. In order to prevent
at least some of the possible precision issues, the lags between subsequent
timestamps are rounded to microseconds during integrity checks. This
corresponds to the maximum value allowed for
\code{\link{options}("digits.secs")}. As a consequence, time series with a
sub-second accuracy higher than a microsecond will never work.
}
\section{Methods}{

A \code{DTSg} object has the following methods:
\itemize{
\item \code{aggregate}: See \code{\link{aggregate}} for further information.
\item \code{alter}: See \code{\link{alter}} for further information.
\item \code{clone}: See \code{\link{clone}} for further information.
\item \code{colapply}: See \code{\link{colapply}} for further information.
\item \code{cols}: See \code{\link{cols}} for further information.
\item \code{getCol}: See \code{\link{getCol}} for further information.
\item \code{merge}: See \code{\link{merge}} for further information.
\item \code{nas}: See \code{\link{nas}} for further information.
\item \code{plot}: See \code{\link{plot}} for further information.
\item \code{print}: See \code{\link{print}} for further information.
\item \code{refresh}: See \code{\link{refresh}} for further information.
\item \code{rollapply}: See \code{\link{rollapply}} for further information.
\item \code{rowaggregate}: See \code{\link{rowaggregate}} for further information.
\item \code{rowbind}: See \code{\link{rowbind}} for further information.
\item \code{setColNames}: See \code{\link{setColNames}} for further information.
\item \code{setCols}: See \code{\link{setCols}} for further information.
\item \code{subset}: See \code{\link{subset}} for further information.
\item \code{summary}: See \code{\link{summary}} for further information.
\item \code{values}: See \code{\link{values}} for further information.
}
}

\section{Fields}{

A \code{DTSg} object has the following fields or properties as they are often
called. They are implemented through so called active bindings, which means
that they can be accessed and actively set with the help of the \code{$} operator,
for instance, \code{x$ID} gets the value of the \code{ID} field and
\code{x$ID <- "River Flow"} sets its value. Please note that fields are always
modified in place, i.e. no deep clone (copy) of the object is made
beforehand. See \code{\link{clone}} for further information. Some of the fields are
read-only though:
\itemize{
\item \code{aggregated}: Same as the \code{aggregated} argument.
\item \code{fast}: Same as the \code{fast} argument.
\item \code{ID}: Same as the \code{ID} argument. It is used as the title of plots.
\item \code{na.status}: Same as the \code{na.status} argument. When set, the missing values
of the object are expanded or collapsed accordingly.
\item \code{parameter}: Same as the \code{parameter} argument. It is used as the label of
the primary axis of plots.
\item \code{periodicity}: A \code{\link{difftime}} object for a regular and a character string
for an irregular \code{DTSg} object describing its periodicity or containing
\code{"unrecognised"} in case it could not be detected. When set, the periodicity
of the time series is changed as specified. See the \code{by} argument of
\code{\link{alter}} for further information.
\item \code{regular}: A logical signalling if all lags in seconds between subsequent
timestamps are the same (\code{TRUE}) or if some are different (\code{FALSE}). A, for
instance, monthly time series is considered irregular in this sense
(read-only).
\item \code{timestamps}: An integer showing the total number of timestamps of the time
series (read-only).
\item \code{timezone}: A character string showing the time zone of the time series.
When set, the series is converted to the specified time zone. Only names from
\code{\link{OlsonNames}} are accepted.
\item \code{unit}: Same as the \code{unit} argument. It is added to the label of the
primary axis of plots when the \code{parameter} field is set.
\item \code{variant}: Same as the \code{variant} argument. It is added to the label of the
primary axis of plots when the \code{parameter} field is set.
}

The \code{parameter}, \code{unit} and \code{variant} fields are especially useful for time
series with a single variable (value column) only.
}

\section{Options}{

The behaviour of \code{DTSg} objects can be customised with the help of the
following option. See \code{\link{options}} for further information:
\itemize{
\item \emph{DTSgClone:} A logical specifying if \code{DTSg} objects are, by default,
modified in place (\code{FALSE}) or if a deep clone (copy) shall be made
beforehand (\code{TRUE}).
}
}

\examples{
# new DTSg object
## R6 constructor
DTSg$new(
  values = flow,
  ID = "River Flow"
)

## abused S4 constructor
new(
  Class = "DTSg",
  values = flow,
  ID = "River Flow"
)

}
