% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_5DTWBI_algorithm_simple_univariate.R
\name{DTWBI_univariate}
\alias{DTWBI_univariate}
\title{DTWBI algorithm for univariate signals}
\usage{
DTWBI_univariate(data, t, T, DTW_method = "DTW", threshold_cos = NULL,
  step_threshold = NULL, step_sim_win = NULL, ...)
}
\arguments{
\item{data}{input vector containing a large and continuous gap (eventually derived from local.derivative.ddtw() function)}

\item{t}{location of the begining of the gap (eventually extracted from gapCreation function)}

\item{T}{gap size (eventually extracted from gapCreation function)}

\item{DTW_method}{DTW method used for imputation ("DTW", "DDTW", "AFBDTW"). By default "DTW".}

\item{threshold_cos}{threshold used to define similar sequences to the query}

\item{step_threshold}{step used within the loop determining the threshold}

\item{step_sim_win}{step used while looking for similar sequences to the query}

\item{...}{additional arguments from the dtw() function}
}
\value{
DTWBI_univariate returns a list containing the following elements:
\itemize{
 \item{output_vector: }{output vector containing complete data including the imputation proposal}
 \item{input_vector: }{original vector used as input}
 \item{query: }{the query i.e. the adjacent sequence to the gap}
 \item{pos_query: }{index of the begining and end of the query}
 \item{sim_window: }{vector containing the values of the most similar sequence to the query}
 \item{pos_sim_window: }{index of the begining and end of the similar window}
 \item{imputation_window: }{vector containing imputed values}
 \item{pos_imp_window: }{index of the begining and end of the imputation window}
}
}
\description{
Imputes values of a gap of position t and size T in a univariate signal based on DTW algorithm.
For more details on the method, see Phan et al. (2017) DOI: <10.1016/j.patrec.2017.08.019>.
Default arguments of dtw() function are used but can be manually explicited and modified.
}
\examples{
data(dataDTWBI)
X <- dataDTWBI[, 1]

rate <- 0.1
output <- gapCreation(X, rate)
data <- output$output_vector
t <- output$begin_gap
T <- output$gap_size
imputed_data <- DTWBI_univariate(data, t, T)
plot(imputed_data$input_vector, type = "l", lwd = 2) # Uncomplete signal
lines(imputed_data$output_vector, col = "red") # Imputed signal
lines(y = imputed_data$query,
      x = imputed_data$pos_query[1]:imputed_data$pos_query[2],
      col = "green", lwd = 4) # Query
lines(y = imputed_data$sim_window,
      x = imputed_data$pos_sim_window[1]:imputed_data$pos_sim_window[2],
      col = "orange", lwd = 4) # Similar sequence to the query
lines(y = imputed_data$imputation_window,
      x = imputed_data$pos_imp_window[1]:imputed_data$pos_imp_window[2],
      col = "blue", lwd = 4) # Imputing proposal
}
\author{
DEZECACHE Camille, PHAN Thi Thu Hong, POISSON-CAILLAULT Emilie
}
