% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dt.sort.R
\name{dt.sort}
\alias{dt.sort}
\title{dt.sort}
\usage{
dt.sort(
  dt.name,
  sorting.variables,
  sort.increasing = TRUE,
  missing.variables = c("first", "last"),
  return.as = "result",
  envir = .GlobalEnv,
  ...
)
}
\arguments{
\item{dt.name}{a character value specifying the name of a data.frame or data.table object to select data from.  A variable called dat should be referred to with dt.name = "dat" when using the function.}

\item{sorting.variables}{A vector specifying the variables that we want to sort by. For character vectors, only values that exist in the names of the data will be used.  For numeric vectors, only the values of unique(floor(sorting.variables)) that are in 1:ncol() of your data will be used.  Then these indices will be used to select column names from the data.  Other values in sorting.variables that do not correspond to a defined column will be excluded from the calculation.  The sorting proceeds in the order that sorting.variables is specified.}

\item{sort.increasing}{A logical vector or numeric vector specifying whether the sorting should be increasing (TRUE or 1) or decreasing (FALSE or not 1) for each variable in sorting.variables.  A vector such as c(TRUE, FALSE) would sort the first variable in increasing order and the second in decreasing order.  If only a single value is provided (either TRUE or FALSE), then all of the.variables will be sorted in the specified ordering.}

\item{missing.variables}{a character value of either "first" or "last" specifying where rows with missing values in the.variables should be included.  Using "first" will place those rows at the beginning of the table, while "last" would place them in the end of the table.}

\item{return.as}{a character value specifying what output should be returned.  return.as = "result" provides the updated data.  return.as = "code" provides a data.table coding statement.  return.as = "all" provides a list object including both the resulting output and the code.}

\item{envir}{a specification of the environment in which the data (referenced by dt.name) exists, with the global environment as the default value.}

\item{...}{additional arguments if required}
}
\value{
Depending on the value of return.as, the output will be a) a character value (return.as = 'code'), b) a coding output, typically a data.table (return.as = 'result'), or c) a list containing both the code and output (return.as = 'all')
}
\description{
This function sorts the rows of a data.frame or data.table based on selected columns.  It is built as a light wrapper function of data.table's setorderv() function.  Options also exist to return a data.table coding statement (result = "code") for educational purposes or both the result and the code together (result = "all").  For examples, please see the vignette.
}
\examples{
n <- nrow(iris)
dat <- data.table::as.data.table(x = iris[sample(x = 1:n, size = n, replace = FALSE),])
dt.sort(dt.name = "dat", sorting.variables = c("Species", "Sepal.Length"),
sort.increasing = TRUE, return.as = "all")
}
