% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_max_min_risk.R
\name{calculate_max_min_risk}
\alias{calculate_max_min_risk}
\title{Calculate risk measures at peak (or minimum)}
\usage{
calculate_max_min_risk(max_min_values_list, D, Dt_max = TRUE)
}
\arguments{
\item{max_min_values_list}{A list generated by \code{\link[=get_max_min_values]{get_max_min_values()}}}

\item{D}{A single threshold value}

\item{Dt_max}{A logical value indicating whether the decision threshold
is a maximum (\code{TRUE}) or a minimum (\code{FALSE}). The default is \code{TRUE}.}
}
\value{
A list of risk measure values.
}
\description{
For each policy alternative, this function calculates the
risk measure at the peak values (or lowest values if the threshold is a minimum).
}
\examples{
tmin <- "2021-01-01"
tmax <- "2021-04-10"
D <- 750

peak_values_list <- get_max_min_values(
  psa_data,
  tmin = tmin,
  tmax = tmax,
  Dt_max = TRUE
)

calculate_max_min_risk(
  peak_values_list,
  D = D,
  Dt_max = TRUE
)
}
