% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataInput.R
\name{dataInput}
\alias{dataInput}
\alias{dataInputUI}
\alias{dataInputServer}
\title{Shiny module for data input}
\usage{
dataInputUI(id, cellWidths = c("50\%", "48\%"))

dataInputServer(
  id,
  data = NULL,
  read_fun = "read.csv",
  read_args = NULL,
  hide = FALSE,
  envir = parent.frame()
)
}
\arguments{
\item{id}{unique identifier for the module to prevent namespace clashes when
making multiple calls to this shiny module.}

\item{cellWidths}{a vector of length 2 to control the relative widths of the
\code{fileInput} and \code{textInput}, set to \code{c("50\%", "50\%")} by
default.}

\item{data}{can be either the name of a dataset or file as a character string
(e.g. "mtcars" or "mtcars.csv") or a vector column names (e.g. c("A", "B",
"C")) or template dimensions (e.g. c(10,10)).}

\item{read_fun}{name of the function to use to read in the data when a file
is selected, set to \code{read.csv} by default.}

\item{read_args}{a named list of additional arguments to pass to
\code{read_fun} when reading in files.}

\item{hide}{logical indicating whether the data input user interface should
be hidden from the user, set to FALSE by default.}

\item{envir}{the environment in which to search for the supplied data, set to
the \code{parent.frame()} of \code{dataInput} by default.}
}
\description{
Shiny module for data input
}
\examples{
if (interactive()) {
  library(shiny)
  library(rhandsontable)

  ui <- fluidPage(
    dataInputUI("input1"),
    rHandsontableOutput("data1")
  )

  server <- function(input,
                     output,
                     session) {
    data_input1 <- dataInputServer("input1")

    output$data1 <- renderRHandsontable({
      if (!is.null(data_input1())) {
        rhandsontable(data_input1())
      }
    })
  }

  shinyApp(ui, server)
}
}
\author{
Dillon Hammill, \email{Dillon.Hammill@anu.edu.au}
}
