% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataSpaceConnection.R
\docType{class}
\name{DataSpaceConnection}
\alias{DataSpaceConnection}
\title{The DataSpaceConnection class}
\usage{
DataSpaceConnection
}
\value{
an instance of \code{DataSpaceConnection}
}
\description{
The DataSpaceConnection class
}
\section{Constructor}{

\code{\link{connectDS}}
}

\section{Fields}{

\describe{
  \item{\code{config}}{
    A list. Stores configuration of the connection object such as
    URL, path and username.
  }
  \item{\code{availableStudies}}{
    A data.table. The table of available studies.
  }
  \item{\code{availableGroups}}{
    A data.table. The table of available groups.
  }
}
}

\section{Methods}{

\describe{
  \item{\code{initialize(login = NULL, password = NULL, verbose = FALSE,
  onStaging = FALSE)}}{
    Initialize a \code{DataSpaceConnection} object.
    See \code{\link{connectDS}}.
  }
  \item{\code{print()}}{
    Print the \code{DataSpaceConnection} object.
  }
  \item{\code{getStudy(study, groupId = NULL)}}{
    Create a \code{\link{DataSpaceStudy}} object.

    \code{study}: A character. Name of the study to retrieve.
  }
  \item{\code{getGroup(groupId)}}{
    Create a \code{\link{DataSpaceStudy}} object.

    \code{groupId}: An integer. ID of the group to retrieve.
  }
  \item{\code{refresh()}}{
    Refresh the connection object to update available studies and groups.
  }
}
}

\examples{
\dontrun{
# Create a connection (Initiate a DataSpaceConnection object)
con <- connectDS()
con

# Connect to cvd408
# https://dataspace.cavd.org/cds/CAVD/app.view#learn/learn/Study/cvd408?q=408
cvd408 <- con$getStudy("cvd408")

# Connect to all studies
cvd <- con$getStudy("cvd408")

# Connect to the NYVAC durability comparison group
# https://dataspace.cavd.org/cds/CAVD/app.view#group/groupsummary/220
nyvac <- con$getGroup(220)

# Refresh the connection object to update available studies and groups
con$refresh()
}

}
\seealso{
\code{\link{connectDS}} \code{\link{DataSpaceR-package}}
}
\keyword{datasets}
