% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Connect.R
\name{connect}
\alias{connect}
\title{connect}
\arguments{
\item{connectionDetails}{An object of class \code{connectionDetails} as created by the
\code{\link{createConnectionDetails}} function.}

\item{dbms}{The type of DBMS running on the server. Valid values are
\itemize{
  \item {"oracle" for Oracle}
  \item {"postgresql" for PostgreSQL}
  \item {"redshift" for Amazon Redshift}
  \item {"sql server" for Microsoft SQL Server}
  \item {"pdw" for Microsoft Parallel Data Warehouse (PDW)}
  \item {"netezza" for IBM Netezza}
  \item {"bigquery" for Google BigQuery}
  \item {"sqlite" for SQLite}
}}

\item{user}{The user name used to access the server.}

\item{password}{The password for that user.}

\item{server}{The name of the server.}

\item{port}{(optional) The port on the server to connect to.}

\item{schema}{(optional) The name of the schema to connect to.}

\item{extraSettings}{(optional) Additional configuration settings specific to the database
provider to configure things as security for SSL. These must follow the
format for the JDBC connection for the RDBMS specified in dbms.}

\item{oracleDriver}{Specify which Oracle drive you want to use. Choose between \code{"thin"}
or \code{"oci"}.}

\item{connectionString}{The JDBC connection string. If specified, the \code{server}, \code{port},
\code{extraSettings}, and \code{oracleDriver} fields are ignored. If
\code{user} and \code{password} are not specified, they are assumed to
already be included in the connection string.}

\item{pathToDriver}{Path to the JDBC driver JAR files. Currently only needed for BigQuery, Impala 
and Netezza. See \link{jdbcDrivers} for details on how to get the drivers.}
}
\value{
An object that extends \code{DBIConnection} in a database-specific manner. This object is used to
direct commands to the database engine.
}
\description{
\code{connect} creates a connection to a database server .There are four ways to call this
function:
\itemize{
  \item \code{connect(dbms, user, password, server, port, schema, extraSettings, oracleDriver,
        pathToDriver)}
  \item \code{connect(connectionDetails)}
  \item \code{connect(dbms, connectionString, pathToDriver))}
  \item \code{connect(dbms, connectionString, user, password, pathToDriver)}
}
}
\details{
This function creates a connection to a database.
}
\section{DBMS parameter details}{
 Depending on the DBMS, the function arguments have slightly different
interpretations: 

Oracle:
\itemize{
  \item \code{user}. The user name used to access the server
  \item \code{password}. The password for that user
  \item \code{server}. This field contains the SID, or host and servicename, SID, or TNSName:
        '<sid>', '<host>/<sid>', '<host>/<service name>', or '<tnsname>'
  \item \code{port}. Specifies the port on the server (default = 1521)
  \item \code{schema}. This field contains the schema (i.e. 'user' in Oracle terms) containing the
        tables
  \item \code{extraSettings} The configuration settings for the connection (i.e. SSL Settings such
        as "(PROTOCOL=tcps)")
  \item \code{oracleDriver} The driver to be used. Choose between "thin" or "oci".
}
Microsoft SQL Server:
\itemize{
  \item \code{user}. The user used to log in to the server. If the user is not specified, Windows
        Integrated Security will be used, which requires the SQL Server JDBC drivers to be installed
        (see details below).
  \item \code{password}. The password used to log on to the server
  \item \code{server}. This field contains the host name of the server
  \item \code{port}. Not used for SQL Server
  \item \code{schema}. The database containing the tables. If both database and schema are specified
        (e.g. 'my_database.dbo', then only the database part is used, the schema is ignored.
  \item \code{extraSettings} The configuration settings for the connection (i.e. SSL Settings such
        as "encrypt=true; trustServerCertificate=false;")
}
Microsoft PDW:
\itemize{
  \item \code{user}. The user used to log in to the server. If the user is not specified, Windows
        Integrated Security will be used, which requires the SQL Server JDBC drivers to be installed
        (see details below).
  \item \code{password}. The password used to log on to the server
  \item \code{server}. This field contains the host name of the server
  \item \code{port}. Not used for SQL Server
  \item \code{schema}. The database containing the tables
  \item \code{extraSettings} The configuration settings for the connection (i.e. SSL Settings such
        as "encrypt=true; trustServerCertificate=false;")
}
PostgreSQL:
\itemize{
  \item \code{user}. The user used to log in to the server
  \item \code{password}. The password used to log on to the server
  \item \code{server}. This field contains the host name of the server and the database holding the
        relevant schemas: <host>/<database>
  \item \code{port}. Specifies the port on the server (default = 5432)
  \item \code{schema}. The schema containing the tables.
  \item \code{extraSettings} The configuration settings for the connection (i.e. SSL Settings such
        as "ssl=true")
}
Redshift:
\itemize{
  \item \code{user}. The user used to log in to the server
  \item \code{password}. The password used to log on to the server
  \item \code{server}. This field contains the host name of the server and the database holding the
        relevant schemas: <host>/<database>
  \item \code{port}. Specifies the port on the server (default = 5439)
  \item \code{schema}. The schema containing the tables.
  \item \code{extraSettings} The configuration settings for the connection (i.e. SSL Settings such
        as "ssl=true&sslfactory=com.amazon.redshift.ssl.NonValidatingFactory")
}
Netezza:
\itemize{
  \item \code{user}. The user used to log in to the server
  \item \code{password}. The password used to log on to the server
  \item \code{server}. This field contains the host name of the server and the database holding the
        relevant schemas: <host>/<database>
  \item \code{port}. Specifies the port on the server (default = 5480)
  \item \code{schema}. The schema containing the tables.
  \item \code{extraSettings} The configuration settings for the connection (i.e. SSL Settings such
        as "ssl=true")
  \item \code{pathToDriver} The path to the folder containing the Netezza JDBC driver JAR file
        (nzjdbc.jar).
}
Impala:
\itemize{
  \item \code{user}. The user name used to access the server
  \item \code{password}. The password for that user
  \item \code{server}. The host name of the server
  \item \code{port}. Specifies the port on the server (default = 21050)
  \item \code{schema}. The database containing the tables
  \item \code{extraSettings} The configuration settings for the connection (i.e. SSL Settings such
        as "SSLKeyStorePwd=*****")
  \item \code{pathToDriver} The path to the folder containing the Impala JDBC driver JAR files.
}
SQLite:
\itemize{
  \item \code{server}. The path to the SQLIte file
}

To be able to use Windows authentication for SQL Server (and PDW), you have to install the JDBC
driver. Download the .exe from
\href{http://www.microsoft.com/en-us/download/details.aspx?displaylang=en&id=11774}{Microsoft} and
run it, thereby extracting its contents to a folder. In the extracted folder you will find the file
sqljdbc_4.0/enu/auth/x64/sqljdbc_auth.dll (64-bits) or sqljdbc_4.0/enu/auth/x86/sqljdbc_auth.dll
(32-bits), which needs to be moved to location on the system path, for example to
c:/windows/system32. If you not have write access to any folder in the system path, you can also 
specify the path to the folder containing the dll by setting the environmental variable 
PATH_TO_AUTH_DLL, so for example \code{Sys.setenv("PATH_TO_AUTH_DLL" = "c:/temp")} Note that the 
environmental variable needs to be set before calling \code{connect} for the first time.
}

\examples{
\dontrun{
conn <- connect(dbms = "postgresql",
                server = "localhost/postgres",
                user = "root",
                password = "xxx",
                schema = "cdm_v4")
dbGetQuery(conn, "SELECT COUNT(*) FROM person")
disconnect(conn)

conn <- connect(dbms = "sql server", server = "RNDUSRDHIT06.jnj.com", schema = "Vocabulary")
dbGetQuery(conn, "SELECT COUNT(*) FROM concept")
disconnect(conn)

conn <- connect(dbms = "oracle",
                server = "127.0.0.1/xe",
                user = "system",
                password = "xxx",
                schema = "test",
                pathToDriver = "c:/temp")
dbGetQuery(conn, "SELECT COUNT(*) FROM test_table")
disconnect(conn)

conn <- connect(dbms = "postgresql",
                connectionString = "jdbc:postgresql://127.0.0.1:5432/cmd_database")
dbGetQuery(conn, "SELECT COUNT(*) FROM person")
disconnect(conn)

}
}
