/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase.toolkit;

import java.util.Vector;
import org.rosuda.ibase.Dependent;
import org.rosuda.ibase.NotifyMsg;
import org.rosuda.ibase.SCatSequence;
import org.rosuda.ibase.SVar;
import org.rosuda.ibase.toolkit.Axis;
import org.rosuda.util.Global;

public class AxisCatSequence
implements Dependent {
    Axis a;
    int[] left;
    int[] right;
    int gap;
    int cats;
    SCatSequence seq;

    AxisCatSequence(Axis axis, SCatSequence sCatSequence) {
        this.a = axis;
        this.seq = sCatSequence;
        this.seq.addDepend(this);
        axis.addDepend(this);
        this.updateCats();
    }

    public void Notifying(NotifyMsg notifyMsg, Object object, Vector vector) {
        this.updateCats();
    }

    void updateCats() {
        int n;
        if (Global.DEBUG > 0) {
            System.out.println("AxisCatSequence.updateCats() [cats=" + this.cats + "]");
        }
        if (this.a.type != 1 && this.a.type != 2) {
            return;
        }
        SVar sVar = this.a.getVariable();
        this.cats = this.seq.size();
        this.left = new int[this.cats];
        this.right = new int[this.cats];
        this.gap = this.a.gap;
        int n2 = 1;
        if (this.a.gLen < 0) {
            n2 = -1;
        }
        if ((n = this.a.gLen - n2 * this.gap * (this.cats - 1)) * this.a.gLen < 0) {
            while (this.gap > 0 && n * this.a.gLen < 0) {
                --this.gap;
                n = this.a.gLen - n2 * this.gap * (this.cats - 1);
            }
            Global.runtimeWarning("AxisCatSequence for Axis[" + this.a.toString() + "]: updateCats: not enough space for categories (" + this.cats + ") if gap (" + this.a.gap + ") is respected. Adjusting gap to " + this.gap);
        }
        boolean bl = this.a.type == 1;
        double d = this.a.gBegin;
        double d2 = n;
        double d3 = bl ? (double)this.cats : (double)sVar.size();
        this.gap *= n2;
        for (int i = 0; i < this.cats; ++i) {
            double d4 = bl ? 1.0 : (double)sVar.getSizeCatAt(this.seq.catAtPos(i));
            this.left[i] = (int)d;
            this.right[i] = (int)(d += d2 * (d4 / d3));
            d += (double)this.gap;
        }
    }

    public int getLowerEdgeOfCatAt(int n) {
        if (this.a.type != 1 && this.a.type != 2) {
            return Global.runtimeWarning("AxisCatSequence for Axis[" + this.a.toString() + "]: getLowerEdgeOfCatAt(" + n + ") but Axis type is not categorical.");
        }
        if (n < 0 || n >= this.cats) {
            return Global.runtimeWarning("AxisCatSequence for Axis[" + this.a.toString() + "]: getLowerEdgeOfCatAt(" + n + ") out of range (cats=" + this.cats + ").");
        }
        if (this.left == null) {
            this.updateCats();
        }
        return this.left[n];
    }

    public int getUpperEdgeOfCatAt(int n) {
        if (this.a.type != 1 && this.a.type != 2) {
            return Global.runtimeWarning("AxisCatSequence for Axis[" + this.a.toString() + "]: getUpperEdgeOfCatAt(" + n + ") but Axis type is not categorical.");
        }
        if (n < 0 || n >= this.cats) {
            return Global.runtimeWarning("AxisCatSequence for Axis[" + this.a.toString() + "]: getUpperEdgeOfCat(" + n + ") out of range (cats=" + this.cats + ").");
        }
        if (this.left == null) {
            this.updateCats();
        }
        return this.right[n];
    }

    public int getCenterOfCatAt(int n) {
        if (this.a.type != 1 && this.a.type != 2) {
            return Global.runtimeWarning("AxisCatSequence for Axis[" + this.a.toString() + "]: getCenterOfCatAt(" + n + ") but Axis type is not categorical.");
        }
        if (n < 0 || n >= this.cats) {
            return Global.runtimeWarning("AxisCatSequence for Axis[" + this.a.toString() + "]: getCenterOfCatAt(" + n + ") out of range (cats=" + this.cats + ").");
        }
        if (this.left == null) {
            this.updateCats();
        }
        return (this.right[n] + this.left[n]) / 2;
    }

    public int getLowerEdgeOfCat(int n) {
        if (this.a.type != 1 && this.a.type != 2) {
            return Global.runtimeWarning("AxisCatSequence for Axis[" + this.a.toString() + "]: getLowerEdgeOfCat(" + n + ") but Axis type is not categorical.");
        }
        if (n < 0 || n >= this.cats) {
            return Global.runtimeWarning("AxisCatSequence for Axis[" + this.a.toString() + "]: getLowerEdgeOfCat(" + n + ") out of range (cats=" + this.cats + ").");
        }
        if (this.left == null) {
            this.updateCats();
        }
        return this.left[this.seq.posOfCat(n)];
    }

    public int getUpperEdgeOfCat(int n) {
        if (this.a.type != 1 && this.a.type != 2) {
            return Global.runtimeWarning("AxisCatSequence for Axis[" + this.a.toString() + "]: getUpperEdgeOfCat(" + n + ") but Axis type is not categorical.");
        }
        if (n < 0 || n >= this.cats) {
            return Global.runtimeWarning("AxisCatSequence for Axis[" + this.a.toString() + "]: getUpperEdgeOfCat(" + n + ") out of range (cats=" + this.cats + ").");
        }
        if (this.left == null) {
            this.updateCats();
        }
        return this.right[this.seq.posOfCat(n)];
    }

    public int getCenterOfCat(int n) {
        if (this.a.type != 1 && this.a.type != 2) {
            return Global.runtimeWarning("AxisCatSequence for Axis[" + this.a.toString() + "]: getCenterOfCat(" + n + ") but Axis type is not categorical.");
        }
        if (n < 0 || n >= this.cats) {
            return Global.runtimeWarning("AxisCatSequence for Axis[" + this.a.toString() + "]: getCenterOfCat(" + n + ") out of range (cats=" + this.cats + ").");
        }
        if (this.left == null) {
            this.updateCats();
        }
        return (this.right[this.seq.posOfCat(n)] + this.left[this.seq.posOfCat(n)]) / 2;
    }

    public int getCatByGeometryPos(int n) {
        if (this.a.type != 1 && this.a.type != 2) {
            return Global.runtimeWarning("AxisCatSequence for Axis[" + this.a.toString() + "]: getCatByGeometryPos(" + n + ") but Axis type is not categorical.");
        }
        if (this.left == null) {
            this.updateCats();
        }
        for (int i = 0; i < this.cats; ++i) {
            int n2 = this.left[i];
            int n3 = this.right[i];
            if (n2 > n3) {
                n3 = n2;
                n2 = this.right[i];
            }
            if (n2 > n || n3 < n) continue;
            return this.seq.catAtPos(i);
        }
        Global.runtimeWarning("AxisCatSequence for Axis[" + this.a.toString() + "]: getCatByGeometryPos(" + n + ") - no category found.");
        return -1;
    }

    public String toString() {
        String string = "AxisCatSequence(cats=" + this.cats;
        for (int i = 0; i < this.cats; ++i) {
            string = string + "," + this.left[i] + ":" + this.right[i];
        }
        return string + ")";
    }
}

