/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase.plots;

import org.rosuda.ibase.SVar;

class OrdStats {
    double med = 0.0;
    double uh = 0.0;
    double lh = 0.0;
    double uh15;
    double lh15;
    double uh3 = 0.0;
    double lh3 = 0.0;
    int[] lastR;
    int lastTop;
    int lowEdge;
    int highEdge;

    OrdStats() {
    }

    private double medFrom(SVar sVar, int[] nArray, int n, int n2) {
        return (n2 - n & 1) == 0 ? sVar.atF(nArray[n + (n2 - n) / 2]) : (sVar.atF(nArray[n + (n2 - n) / 2]) + sVar.atF(nArray[n + (n2 - n) / 2 + 1])) / 2.0;
    }

    void update(SVar sVar, int[] nArray) {
        this.update(sVar, nArray, nArray.length);
    }

    void update(SVar sVar, int[] nArray, int n) {
        double d;
        int n2;
        this.lastTop = n;
        if (n < 1) {
            return;
        }
        this.med = this.medFrom(sVar, nArray, 0, n - 1);
        this.uh = this.medFrom(sVar, nArray, n / 2, n - 1);
        this.lh = n > 1 && (n & 1) == 1 ? this.medFrom(sVar, nArray, 0, n / 2 - 1) : this.medFrom(sVar, nArray, 0, n / 2);
        this.lh15 = this.lh - 1.5 * (this.uh - this.lh);
        this.lh3 = this.lh - 3.0 * (this.uh - this.lh);
        double d2 = this.lh;
        for (n2 = n / 4; n2 >= 0 && !((d = sVar.atF(nArray[n2])) < this.lh15); --n2) {
            if (!(d < d2)) continue;
            d2 = d;
        }
        this.lowEdge = n2;
        this.lh15 = d2;
        this.uh15 = this.uh + 1.5 * (this.uh - this.lh);
        this.uh3 = this.uh + 3.0 * (this.uh - this.lh);
        d2 = this.uh;
        n2 = n * 3 / 4 - 1;
        if (n2 < 0) {
            n2 = 0;
        }
        while (n2 < n && !((d = sVar.atF(nArray[n2])) > this.uh15)) {
            if (d > d2) {
                d2 = d;
            }
            ++n2;
        }
        this.uh15 = d2;
        this.highEdge = n2;
        this.lastR = nArray;
    }
}

