/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase.toolkit;

import java.awt.Color;
import org.rosuda.ibase.Common;
import org.rosuda.ibase.toolkit.PlotManager;
import org.rosuda.ibase.toolkit.PlotObject;
import org.rosuda.pograss.PoGraSS;

public class PlotText
extends PlotObject {
    int[] dx;
    int[] dy;
    int[] maxw;
    int[] maxh;
    double[] ax;
    double[] ay;
    double[] x;
    double[] y;
    double[] rot;
    String[] txt;
    boolean show = true;

    public PlotText(PlotManager plotManager) {
        super(plotManager);
    }

    public void clear() {
        this.y = null;
        this.x = null;
        this.dy = null;
        this.dx = null;
        this.ay = null;
        this.ax = null;
        this.rot = null;
        this.maxw = null;
        this.maxh = null;
        this.txt = null;
    }

    public void draw(PoGraSS poGraSS) {
        if (!this.show || this.txt == null || this.txt.length == 0) {
            return;
        }
        if (this.cold != null) {
            this.cold.use(poGraSS);
        }
        for (int i = 0; i < this.txt.length; ++i) {
            boolean bl;
            double d;
            if (this.txt[i] == null) continue;
            double d2 = 0.0;
            if (this.rot != null && this.rot.length > 0) {
                d2 = this.rot[i % this.rot.length];
            }
            if ((d = d2 < 0.0 ? d2 - (double)((int)(d2 / 360.0 + 1.0) * 360) : d2 - (double)((int)(d2 / 360.0) * 360)) < 1.0E-6 || d > 359.999999) {
                String string = this.maxw != null && this.maxw[i] >= 0 && poGraSS.getWidthEstimate(this.txt[i]) > this.maxw[i] ? Common.getTriGraph(this.txt[i]) : this.txt[i];
                poGraSS.setColor(Color.BLACK);
                double d3 = 0.0;
                double d4 = 0.0;
                if (this.ax != null && this.ax.length > 0) {
                    d3 = this.ax[i % this.ax.length];
                }
                if (this.ay != null && this.ay.length > 0) {
                    d4 = this.ay[i % this.ay.length];
                }
                poGraSS.drawString(string, this.dx[i], this.dy[i], d3, d4);
                continue;
            }
            double d5 = d * Math.PI / 180.0;
            double d6 = Math.sin(d5);
            double d7 = Math.cos(d5);
            int n = poGraSS.getWidthEstimate(this.txt[i]);
            int n2 = poGraSS.getHeightEstimate(this.txt[i]);
            int n3 = (int)Math.ceil((double)n2 * Math.abs(d6) + (double)n * Math.abs(d7));
            int n4 = (int)Math.ceil((double)n * Math.abs(d6) + (double)n2 * Math.abs(d7));
            boolean bl2 = bl = this.maxw != null && this.maxw[i] >= 0 && n3 > this.maxw[i];
            if (!bl && this.maxh[i] >= 0 && n4 > this.maxh[i]) {
                bl = true;
            }
            String string = bl ? Common.getTriGraph(this.txt[i]) : this.txt[i];
            poGraSS.setColor(Color.BLACK);
            double d8 = 0.0;
            double d9 = 0.0;
            if (this.ax != null && this.ax.length > 0) {
                d8 = this.ax[i % this.ax.length];
            }
            if (this.ay != null && this.ay.length > 0) {
                d9 = this.ay[i % this.ay.length];
            }
            poGraSS.drawString(string, this.dx[i], this.dy[i], d8, d9, d2);
        }
    }

    public void set(double d, double d2) {
        this.x = new double[1];
        this.x[0] = d;
        this.y = new double[1];
        this.y[0] = d2;
        this.recalc();
    }

    public void set(double[] dArray, double[] dArray2) {
        if (dArray == null) {
            this.x = null;
        } else {
            this.x = new double[dArray.length];
            System.arraycopy(dArray, 0, this.x, 0, dArray.length);
        }
        if (dArray2 == null) {
            this.y = null;
        } else {
            this.y = new double[dArray2.length];
            System.arraycopy(dArray2, 0, this.y, 0, dArray2.length);
        }
        this.recalc();
    }

    public double[] getX() {
        return this.x;
    }

    public double[] getY() {
        return this.y;
    }

    public double[] getAX() {
        return this.ax;
    }

    public double[] getAY() {
        return this.ay;
    }

    public int[] getDX() {
        return this.dx;
    }

    public int[] getDY() {
        return this.dy;
    }

    public void set(String string) {
        this.txt = new String[1];
        this.txt[0] = string;
    }

    public void set(String[] stringArray) {
        this.txt = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.txt, 0, stringArray.length);
    }

    public void setAX(double d) {
        this.ax = new double[1];
        this.ax[0] = d;
    }

    public void setAX(double[] dArray) {
        this.ax = new double[dArray.length];
        System.arraycopy(dArray, 0, this.ax, 0, dArray.length);
    }

    public void setAY(double d) {
        this.ay = new double[1];
        this.ay[0] = d;
    }

    public void setAY(double[] dArray) {
        this.ay = new double[dArray.length];
        System.arraycopy(dArray, 0, this.ay, 0, dArray.length);
    }

    public String toString() {
        if (this.txt == null) {
            return "PlotText(<no text>)";
        }
        if (this.x == null || this.y == null) {
            return "PlotText(<coordinates incomplete>)";
        }
        int n = this.txt.length;
        if (this.x.length > n) {
            n = this.x.length;
        }
        if (this.y.length > n) {
            n = this.y.length;
        }
        return "PlotText(labels=" + n + ",coord=" + this.coordX + "/" + this.coordY + ",visible=" + this.isVisible() + ")";
    }

    public void recalc() {
        int n;
        if (this.x == null || this.y == null) {
            return;
        }
        int n2 = n = this.x.length > this.y.length ? this.y.length : this.x.length;
        if (this.dx == null || this.dy == null || this.dx.length != n || this.dy.length != n) {
            this.dx = new int[n];
            this.dy = new int[n];
        }
        for (int i = 0; i < n; ++i) {
            this.dx[i] = this.getXPos(this.x[i % this.x.length]);
            this.dy[i] = this.getYPos(this.y[i % this.y.length]);
        }
    }

    int getMaxBoundingBoxWidth(PoGraSS poGraSS) {
        int n = 0;
        if (this.txt != null) {
            for (int i = 0; i < this.txt.length; ++i) {
                if (this.txt[i] == null) continue;
                double d = 0.0;
                if (this.rot != null && this.rot.length > 0) {
                    d = this.rot[i % this.rot.length];
                }
                double d2 = d * Math.PI / 180.0;
                double d3 = Math.sin(d2);
                double d4 = Math.cos(d2);
                int n2 = poGraSS.getWidthEstimate(this.txt[i]);
                int n3 = poGraSS.getHeightEstimate(this.txt[i]);
                int n4 = (int)Math.ceil((double)n3 * Math.abs(d3) + (double)n2 * Math.abs(d4));
                n = Math.max(n, n4);
            }
        }
        return n;
    }
}

