/*
 * Decompiled with CFR 0.152.
 */
package edu.cens.spatial;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import org.rosuda.JGR.DataLoader;
import org.rosuda.JGR.editor.Editor;
import org.rosuda.JGR.toolkit.AboutDialog;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.data.DataViewer;
import org.rosuda.deducer.data.VariableView;
import org.rosuda.deducer.toolkit.SaveData;
import org.rosuda.ibase.Common;
import org.rosuda.ibase.toolkit.EzMenuSwing;

public class SpatialVariableView
extends VariableView {
    public SpatialVariableView(String string) {
        super(string + "@data");
    }

    public void setData(String string) {
        super.setData(string + "@data");
    }

    public JMenuBar generateMenuBar() {
        JFrame jFrame = new JFrame();
        String[] stringArray = new String[]{"+", "File", "@NNew Data", "newdata", "@LOpen Data", "loaddata", "@SSave Data", "Save Data", "-", "-", "@PPrint", "print", "~File.Quit", "+", "Edit", "@CCopy", "copy", "@XCut", "cut", "@VPaste", "paste", "-", "Remove Data from Workspace", "Clear Data", "~Window", "+", "Help", "R Help", "help", "~About", "0"};
        JMenuBar jMenuBar = EzMenuSwing.getEzMenu((JFrame)jFrame, (ActionListener)((Object)this), (String[])stringArray);
        if (!Common.isMac()) {
            EzMenuSwing.addMenuSeparator((JFrame)jFrame, (String)"Edit");
            EzMenuSwing.addJMenuItem((JFrame)jFrame, (String)"Help", (String)"About", (String)"about", (ActionListener)((Object)this));
            for (int i = 0; i < jMenuBar.getMenuCount(); ++i) {
                if (!jMenuBar.getMenu(i).getText().equals("About")) continue;
                jMenuBar.remove(i);
                --i;
            }
        }
        return jFrame.getJMenuBar();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            String string = actionEvent.getActionCommand();
            if (string == "Open Data") {
                new DataLoader();
            } else if (string == "Save Data") {
                new SaveData(this.dataName);
            } else if (string == "Clear Data") {
                if (this.dataName == null) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Invalid selection: There is no data loaded.");
                    return;
                }
                int n = JOptionPane.showConfirmDialog(null, "Remove Data Frame " + this.dataName + " from enviornment?\n" + "Unsaved changes will be lost.", "Clear Data Frame", 0, 3);
                if (n == 1) {
                    return;
                }
                Deducer.execute((String)("rm(" + this.dataName + ")"));
            } else if (string == "about") {
                new AboutDialog(null);
            } else if (string == "cut") {
                this.ex.cutSelection();
            } else if (string == "copy") {
                this.ex.copySelection();
            } else if (string == "paste") {
                this.ex.pasteSelection();
            } else if (string == "print") {
                try {
                    this.ex.print(JTable.PrintMode.NORMAL);
                }
                catch (Exception exception) {}
            } else if (string == "editor") {
                new Editor();
            } else if (string == "exit") {
                ((JFrame)this.getTopLevelAncestor()).dispose();
            } else if (string == "newdata") {
                String string2 = JOptionPane.showInputDialog("Data Name: ");
                if ((string2 = Deducer.getUniqueName((String)string2)) != null) {
                    Deducer.execute((String)(string2.trim() + "<-data.frame(Var1=NA)"));
                }
            } else if (string == "loaddata") {
                DataLoader dataLoader = new DataLoader();
            } else if (string == "help") {
                Deducer.execute((String)"help.start()");
            } else if (string == "table") {
                DataViewer dataViewer = new DataViewer();
                dataViewer.setLocationRelativeTo(null);
                dataViewer.setVisible(true);
            } else if (string == "save") {
                new SaveData(this.dataName);
            }
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void cleanUp() {
    }
}

