/*
 * Decompiled with CFR 0.152.
 */
package edu.cens.text;

import edu.cens.text.TermFrequencyDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public abstract class AbstractTermFrequencyViewer {
    JComboBox sortMethodSelector;
    private boolean decreasing;
    protected TermFrequencyDialog tfDialog;

    public abstract JPanel getOptionsPanel();

    public abstract String toString();

    public abstract void executeView();

    public AbstractTermFrequencyViewer(TermFrequencyDialog termFrequencyDialog) {
        this.tfDialog = termFrequencyDialog;
        this.decreasing = true;
    }

    public void onCorpusChange(String string) {
    }

    public String getExtraTermFreqArgs() {
        return "sorted=\"" + this.getSortMethod() + "\", " + "decreasing=" + ("" + this.getAsc()).toUpperCase();
    }

    protected GridBagConstraints getTopLevelLayoutDefaults() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        return gridBagConstraints;
    }

    public String getSortMethod() {
        if (this.sortMethodSelector == null) {
            return "freq";
        }
        if (this.sortMethodSelector.getSelectedItem().equals("by frequency")) {
            return "freq";
        }
        if (this.sortMethodSelector.getSelectedItem().equals("alphanumerically")) {
            return "alpha";
        }
        throw new IllegalStateException("Unrecognized value '" + this.sortMethodSelector.getSelectedItem() + "'  from combo box!");
    }

    public boolean getAsc() {
        return this.decreasing;
    }

    protected JPanel constructSortPanel() {
        GridBagConstraints gridBagConstraints = this.getTopLevelLayoutDefaults();
        JPanel jPanel = new JPanel(new GridBagLayout());
        JRadioButton jRadioButton = new JRadioButton("descending");
        JRadioButton jRadioButton2 = new JRadioButton("ascending");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractTermFrequencyViewer.this.decreasing = false;
            }
        });
        jRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractTermFrequencyViewer.this.decreasing = true;
            }
        });
        jRadioButton.setSelected(true);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)new JLabel("Sort:"), gridBagConstraints);
        this.sortMethodSelector = new JComboBox();
        this.sortMethodSelector.addItem("by frequency");
        this.sortMethodSelector.addItem("alphanumerically");
        this.sortMethodSelector.setSelectedIndex(0);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.sortMethodSelector, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints = this.getTopLevelLayoutDefaults();
        jPanel2.add((Component)jRadioButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel2.add((Component)jRadioButton2, gridBagConstraints);
        gridBagConstraints = this.getTopLevelLayoutDefaults();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        return jPanel;
    }
}

