% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{methods}
\name{depthMedian}
\alias{depthMedian}
\alias{depthMedian,Depth}
\alias{depthMedian,Depth-method}
\alias{depthMedian,data.frame}
\alias{depthMedian,data.frame-method}
\alias{depthMedian,matrix}
\alias{depthMedian,matrix-method}
\title{Depth median}
\usage{
depthMedian(x, ...)

\S4method{depthMedian}{matrix}(x, ...)

\S4method{depthMedian}{data.frame}(x, ...)

\S4method{depthMedian}{Depth}(x)
}
\arguments{
\item{x}{object of class Depth or matrix.}

\item{...}{arguments passed to \code{\link{depth}} function (e.g method).}
}
\description{
Return point with maximum depth function value. If multiple points have the same value, mean average of them will be returned.
}
\examples{
# depthMedian for matrix
x = matrix(rnorm(600), nc = 3)
depthMedian(x)

# depthMedian works with object of class Depth
dp = depth(x)
depthMedian(dp)
}

