% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/roll_palette.R
\name{roll_palette}
\alias{roll_palette}
\title{Create a simple color palette}
\usage{
roll_palette(number, hue_range = c(0, 360), chroma_range = c(0, 3),
  lightness_range = c(0.75, 1.5), alpha = NULL, display_colors = TRUE)
}
\arguments{
\item{number}{the number of colors to include in the palette.}

\item{hue_range}{a vector representing a range of hues from \code{0} to \code{360}.}

\item{chroma_range}{a vector representing a range of chroma values from \code{0} to \code{3}.}

\item{lightness_range}{a vector representing a range of lightness values from \code{0} to \code{2}.}

\item{alpha}{an optional alpha value in the range of \code{0}-\code{100} to append to the hexadecimal color values.}

\item{display_colors}{an option for displaying the rolled color palette in the RStudio Viewer pane.}
}
\value{
a vector of hexadecimal color values.
}
\description{
Generate a randomized set of colors from the CIE Lab color space using a set of HCL range values.
}
\examples{
\dontrun{
# Create a palette of 12 colors
roll_palette(number = 12,
             hue_range = c(0, 360),
             chroma_range = c(0, 3),
             lightness_range = c(0.75, 1.5),
             alpha = NULL,
             display_colors = TRUE)

#> [1] "#F7DC9D" "#D937E5" "#8880B9" "#119F35" "#7CEAB7"
#> [6] "#F8877D" "#C08B1B" "#B1E2F9" "#8E9573" "#74A31C"
#> [11] "#51A053" "#50C9A4"
}
}

