% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edge_info.R
\name{edge_info}
\alias{edge_info}
\title{Get detailed information on edges}
\usage{
edge_info(graph)
}
\arguments{
\item{graph}{a graph object of class \code{dgr_graph}.}
}
\value{
a data frame containing information specific to each edge within
the graph.
}
\description{
Obtain a data frame with detailed information on edges and
their interrelationships within a graph.
}
\examples{
\dontrun{
# Create a simple graph and get edge information from it
nodes <-
  create_nodes(nodes = LETTERS,
               label = TRUE,
               type = c(rep("a_to_g", 7),
                        rep("h_to_p", 9),
                        rep("q_to_x", 8),
                        rep("y_and_z",2)))

edges <-
  create_edges(from = sample(LETTERS, replace = TRUE),
               to = sample(LETTERS, replace = TRUE),
               rel = "letter_to_letter")

graph <-
  create_graph(nodes_df = nodes,
               edges_df = edges,
               graph_attrs = "layout = neato",
               node_attrs = c("fontname = Helvetica",
                              "shape = circle"))

edge_info(graph)
#>    from   to              rel
#> 1     A    Z letter_to_letter
#> 2     H    U letter_to_letter
#> 3     W    O letter_to_letter
#> 4     U    K letter_to_letter
#> 5     I    V letter_to_letter
#>..   ...  ...              ...
}
}

