% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dice_similarity.R
\name{get_dice_similarity}
\alias{get_dice_similarity}
\title{Get Dice similarity coefficient scores}
\usage{
get_dice_similarity(graph, nodes = NULL, direction = "all", round_to = 3)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{nodes}{an optional vector of node IDs to
consider for Dice similarity scores. If notsupplied,
then similarity scores will be provided for every
pair of nodes in the graph.}

\item{direction}{using \code{all} (the default), the
function will ignore edge direction when
determining scores for neighboring nodes. With
\code{out} and \code{in}, edge direction for
neighboring nodes will be considered.}

\item{round_to}{the maximum number of decimal places
to retain for the Dice similarity coefficient
scores. The default value is \code{3}.}
}
\value{
a matrix with Dice similiarity values
for each pair of nodes considered.
}
\description{
Get the Dice similiarity coefficient
scores for one or more nodes in a graph.
}
\examples{
# Create a random graph
graph <-
  create_random_graph(
    10, 22, set_seed = 1)

# Get the Dice similarity values for
# nodes `5`, `6`, and `7`
get_dice_similarity(graph, 5:7)
#>       5     6     7
#> 5 1.000 0.444 0.667
#> 6 0.444 1.000 0.444
#> 7 0.667 0.444 1.000
}

