% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invert_selection.R
\name{invert_selection}
\alias{invert_selection}
\title{Invert selection of nodes or edges in a graph}
\usage{
invert_selection(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
Modify the selection of nodes or edges
within a graph object such that all nodes or edges
previously unselected will now be selected and vice
versa.
}
\examples{
# Create a node data frame (ndf)
ndf <-
  create_node_df(
    n = 4,
    type = "standard")

# Create an edge data frame (edf)
edf <-
  create_edge_df(
    from = c(1, 2, 3),
    to = c(4, 3, 1),
    rel = "leading_to")

# Create a graph
graph <-
  create_graph(
    nodes_df = ndf,
    edges_df = edf)

# Select nodes with ID values `1` and `3`
graph <-
  select_nodes(
    graph = graph,
    nodes = c(1, 3))

# Verify that a node selection has been made
get_selection(graph)
#> [1] 1 3

# Invert the selection
graph <- invert_selection(graph)

# Verify that the node selection has been changed
get_selection(graph)
#> [1] 2 4
}

