% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_complement_graph.R
\name{create_complement_graph}
\alias{create_complement_graph}
\title{Create a complement of a graph}
\usage{
create_complement_graph(graph, loops = FALSE)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph} that is created using
\code{create_graph}.}

\item{loops}{an option for whether loops should
be generated in the complement graph.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
Create a complement graph which
contains only edges not present in the input graph.
}
\examples{
# Create a simple graph with a single cycle
graph <-
  create_graph() \%>\%
  add_cycle(n = 4)

# Get the graph's edge data frame
graph \%>\%
  get_edge_df()
#>   id from to  rel
#> 1  1    1  2 <NA>
#> 2  2    2  3 <NA>
#> 3  3    3  4 <NA>
#> 4  4    4  1 <NA>

# Create the complement of the graph
graph_c <- create_complement_graph(graph)

# Get the edge data frame for the
# complement graph
graph_c \%>\%
  get_edge_df()
#>   id from to  rel
#> 1  1    1  4 <NA>
#> 2  2    1  3 <NA>
#> 3  3    2  4 <NA>
#> 4  4    2  1 <NA>
#> 5  5    3  2 <NA>
#> 6  6    3  1 <NA>
#> 7  7    4  3 <NA>
#> 8  8    4  2 <NA>
}
