% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_adhesion.R
\name{get_adhesion}
\alias{get_adhesion}
\title{Get graph adhesion}
\usage{
get_adhesion(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}
}
\value{
a single numeric value representing the
minimum number of edges to remove.
}
\description{
Get the adhesion of a graph, which is
the minimum number of edges needed to remove to obtain
a graph which is not strongly connected. This is the
same as the edge connectivity of the graph.
}
\examples{
# Create a cycle graph
graph <-
  create_graph() \%>\%
  add_cycle(n = 5)

# Determine the graph's adhesion
graph \%>\%
  get_adhesion()

# Create a full graph and then
# get the adhesion for that
create_graph() \%>\%
  add_full_graph(n = 8) \%>\%
  get_adhesion()
}
