% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform_to_subgraph_ws.R
\name{transform_to_subgraph_ws}
\alias{transform_to_subgraph_ws}
\title{Create a subgraph using node/edge selection}
\usage{
transform_to_subgraph_ws(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph} that is created using
\code{create_graph}.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
Create a subgraph based on a
selection of nodes or edges stored in the graph
object. Selections of nodes can be performed using
the following \code{select_...} functions:
\code{select_nodes()},
\code{select_last_nodes_created()},
\code{select_nodes_by_degree()},
\code{select_nodes_by_id()}, or
\code{select_nodes_in_neighborhood()}.
Alternatively, selections of edges can be made
with these functions: \code{select_edges()},
\code{select_last_edge()}, or
\code{select_edges_by_node_id()}. Selections of
nodes or edges can also be performed using
any of the traversal functions (\code{trav_...}).
}
\examples{
# Create a node data frame (ndf)
ndf <-
  create_node_df(
    n = 6,
    value =
      c(3.5, 2.6, 9.4,
        2.7, 5.2, 2.1))

# Create an edge data frame (edf)
edf <-
  create_edge_df(
    from = c(1, 2, 4, 5, 2, 6),
      to = c(2, 4, 1, 3, 5, 5))

# Create a graph
graph <-
  create_graph(
    nodes_df = ndf,
    edges_df = edf)

# Create a selection of nodes, this selects
# nodes `1`, `3`, and `5`
graph <-
  graph \%>\%
  select_nodes(
    conditions = value > 3)

# Create a subgraph based on the selection
subgraph <-
  graph \%>\%
  transform_to_subgraph_ws()

# Display the graph's node data frame
subgraph \%>\%
  get_node_df()

# Display the graph's edge data frame
subgraph \%>\%
  get_edge_df()
}
