% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_edges_from_table.R
\name{add_edges_from_table}
\alias{add_edges_from_table}
\title{Add edges and attributes to graph from a table}
\usage{
add_edges_from_table(
  graph,
  table,
  from_col,
  to_col,
  from_to_map,
  rel_col = NULL,
  set_rel = NULL,
  drop_cols = NULL
)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{table}{Either a path to a CSV file, or, a data frame object.}

\item{from_col}{The name of the table column from which edges originate.}

\item{to_col}{The name of the table column to which edges terminate.}

\item{from_to_map}{A single character value for the mapping of the \code{from} and
\code{to} columns in the external table (supplied as \code{from_col} and \code{to_col},
respectively) to a column in the graph's internal node data frame (ndf).}

\item{rel_col}{An option to apply a column of data in the table as \code{rel}
attribute values.}

\item{set_rel}{an optional string to apply a \code{rel} attribute to all edges
created from the table records.}

\item{drop_cols}{An optional column selection statement for dropping columns
from the external table before inclusion as attributes in the graph's
internal edge data frame. Several columns can be dropped by name using the
syntax \code{col_1 & col_2 & ...}. Columns can also be dropped using a numeric
column range with \code{:} (e.g., \code{5:8}), or, by using the \code{:} between column
names to specify the range (e.g., \code{col_5_name:col_8_name}).}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
Add edges and their attributes to an existing graph object from data in a CSV
file or a data frame.
}
\examples{
# Create an empty graph and then
# add nodes to it from the
# `currencies` dataset available
# in the package
graph <-
  create_graph() \%>\%
  add_nodes_from_table(
    table = currencies)

# Now we want to add edges to the
# graph using an included dataset,
# `usd_exchange_rates`, which has
# exchange rates between USD and
# many other currencies; the key
# here is that the data in the
# `from` and `to` columns in the
# external table maps to graph
# node data available in the
# `iso_4217_code` column of the
# graph's internal node data frame
graph_1 <-
  graph \%>\%
    add_edges_from_table(
      table = usd_exchange_rates,
      from_col = from_currency,
      to_col = to_currency,
      from_to_map = iso_4217_code)

# View part of the graph's
# internal edge data frame
graph_1 \%>\%
  get_edge_df() \%>\%
  head()

# If you would like to assign
# any of the table's columns as the
# `rel` attribute, this can done
# with the `rel_col` argument; to
# set a static `rel` attribute for
# all edges created, use `set_rel`
graph_2 <-
  graph \%>\%
    add_edges_from_table(
      table = usd_exchange_rates,
      from_col = from_currency,
      to_col = to_currency,
      from_to_map = iso_4217_code,
      set_rel = "from_usd")

# View part of the graph's internal
# edge data frame (edf)
graph_2 \%>\%
  get_edge_df() \%>\%
  head()

}
\seealso{
Other Edge creation and removal: 
\code{\link{add_edge_clone}()},
\code{\link{add_edge_df}()},
\code{\link{add_edges_w_string}()},
\code{\link{add_edge}()},
\code{\link{add_forward_edges_ws}()},
\code{\link{add_reverse_edges_ws}()},
\code{\link{copy_edge_attrs}()},
\code{\link{create_edge_df}()},
\code{\link{delete_edges_ws}()},
\code{\link{delete_edge}()},
\code{\link{delete_loop_edges_ws}()},
\code{\link{drop_edge_attrs}()},
\code{\link{edge_data}()},
\code{\link{join_edge_attrs}()},
\code{\link{mutate_edge_attrs_ws}()},
\code{\link{mutate_edge_attrs}()},
\code{\link{recode_edge_attrs}()},
\code{\link{rename_edge_attrs}()},
\code{\link{rescale_edge_attrs}()},
\code{\link{rev_edge_dir_ws}()},
\code{\link{rev_edge_dir}()},
\code{\link{set_edge_attr_to_display}()},
\code{\link{set_edge_attrs_ws}()},
\code{\link{set_edge_attrs}()}
}
\concept{Edge creation and removal}
