% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_edge_attrs.R
\name{drop_edge_attrs}
\alias{drop_edge_attrs}
\title{Drop an edge attribute column}
\usage{
drop_edge_attrs(graph, edge_attr)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{edge_attr}{The name of the edge attribute column to drop.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
Within a graph's internal edge data frame (edf), remove an existing edge
attribute.
}
\examples{
# Create a random graph using the
# `add_gnm_graph()` function
graph <-
  create_graph() \%>\%
  add_gnm_graph(
    n = 5,
    m = 6,
    set_seed = 23) \%>\%
  set_edge_attrs(
    edge_attr = value,
    values = 3) \%>\%
  mutate_edge_attrs(
    penwidth = value * 2)

# Get the graph's internal
# edf to show which edge
# attributes are available
graph \%>\% get_edge_df()

# Drop the `value` edge
# attribute
graph <-
  graph \%>\%
  drop_edge_attrs(
    edge_attr = value)

# Get the graph's internal
# edf to show that the edge
# attribute `value` had been
# removed
graph \%>\% get_edge_df()

}
\seealso{
Other Edge creation and removal: 
\code{\link{add_edge_clone}()},
\code{\link{add_edge_df}()},
\code{\link{add_edges_from_table}()},
\code{\link{add_edges_w_string}()},
\code{\link{add_edge}()},
\code{\link{add_forward_edges_ws}()},
\code{\link{add_reverse_edges_ws}()},
\code{\link{copy_edge_attrs}()},
\code{\link{create_edge_df}()},
\code{\link{delete_edges_ws}()},
\code{\link{delete_edge}()},
\code{\link{delete_loop_edges_ws}()},
\code{\link{edge_data}()},
\code{\link{join_edge_attrs}()},
\code{\link{mutate_edge_attrs_ws}()},
\code{\link{mutate_edge_attrs}()},
\code{\link{recode_edge_attrs}()},
\code{\link{rename_edge_attrs}()},
\code{\link{rescale_edge_attrs}()},
\code{\link{rev_edge_dir_ws}()},
\code{\link{rev_edge_dir}()},
\code{\link{set_edge_attr_to_display}()},
\code{\link{set_edge_attrs_ws}()},
\code{\link{set_edge_attrs}()}
}
\concept{Edge creation and removal}
