% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_n_nodes_ws.R
\name{add_n_nodes_ws}
\alias{add_n_nodes_ws}
\title{Add a multiple of new nodes with edges to or from one or more selected nodes}
\usage{
add_n_nodes_ws(
  graph,
  n,
  direction = NULL,
  type = NULL,
  label = NULL,
  rel = NULL,
  node_aes = NULL,
  edge_aes = NULL,
  node_data = NULL,
  edge_data = NULL
)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{n}{The number of new nodes to attach as successor nodes to the nodes in
the selection.}

\item{direction}{Using \code{from} will create new edges from existing nodes to
the new nodes. The \code{to} option will create new edges directed toward the
existing nodes.}

\item{type}{An optional character vector that provides group identifiers for
the nodes to be added.}

\item{label}{An optional character object that describes the nodes to be
added.}

\item{rel}{An optional string to apply a \code{rel} attribute to all newly created
edges.}

\item{node_aes}{An optional list of named vectors comprising node aesthetic
attributes. The helper function \code{\link[=node_aes]{node_aes()}} is strongly recommended for
use here as it contains arguments for each of the accepted node aesthetic
attributes (e.g., \code{shape}, \code{style}, \code{color}, \code{fillcolor}).}

\item{edge_aes}{An optional list of named vectors comprising edge aesthetic
attributes. The helper function \code{\link[=edge_aes]{edge_aes()}} is strongly recommended for
use here as it contains arguments for each of the accepted edge aesthetic
attributes (e.g., \code{shape}, \code{style}, \code{penwidth}, \code{color}).}

\item{node_data}{An optional list of named vectors comprising node data
attributes. The helper function \code{\link[=node_data]{node_data()}} is strongly recommended for
use here as it helps bind data specifically to the created nodes.}

\item{edge_data}{An optional list of named vectors comprising edge data
attributes. The helper function \code{\link[=edge_data]{edge_data()}} is strongly recommended for
use here as it helps bind data specifically to the created edges.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
Add \code{n} new nodes to or from one or more nodes available as a selection in a
graph object of class \code{dgr_graph}. New graph edges will all move either from
the nodes in the selection toward the newly created nodes (with the option
\code{direction = "from"}), or to the selected nodes already in the graph (using
\code{direction = "to"}). Optionally, set node \code{type} and edge \code{rel} values for
all the new nodes and edges created, respectively.
}
\details{
This function makes use of an active selection of nodes (and the function
ending with \verb{_ws} hints at this).

Selections of nodes can be performed using the following node selection
(\verb{select_*()}) functions: \code{\link[=select_nodes]{select_nodes()}}, \code{\link[=select_last_nodes_created]{select_last_nodes_created()}},
\code{\link[=select_nodes_by_degree]{select_nodes_by_degree()}}, \code{\link[=select_nodes_by_id]{select_nodes_by_id()}}, or
\code{\link[=select_nodes_in_neighborhood]{select_nodes_in_neighborhood()}}.

Selections of nodes can also be performed using the following traversal
(\verb{trav_*()}) functions: \code{\link[=trav_out]{trav_out()}}, \code{\link[=trav_in]{trav_in()}}, \code{\link[=trav_both]{trav_both()}},
\code{\link[=trav_out_node]{trav_out_node()}}, \code{\link[=trav_in_node]{trav_in_node()}}, \code{\link[=trav_out_until]{trav_out_until()}}, or
\code{\link[=trav_in_until]{trav_in_until()}}.
}
\examples{
# Create an empty graph, add a node to it, select
# that node, and then add 5 more nodes to the graph
# with edges from the original node to all of the
# new nodes
graph <-
  create_graph() \%>\%
  add_n_nodes(n = 1) \%>\%
  select_last_nodes_created() \%>\%
  add_n_nodes_ws(
    n = 5,
    direction = "from")

# Get the graph's nodes
graph \%>\% get_node_ids()

# Get the graph's edges
graph \%>\% get_edges()

# Create an empty graph, add a node to it, select
# that node, and then add 5 more nodes to the graph
# with edges toward the original node from all of
# the new nodes
graph <-
  create_graph() \%>\%
  add_n_nodes(n = 1) \%>\%
  select_last_nodes_created() \%>\%
  add_n_nodes_ws(
    n = 5,
    direction = "to")

# Get the graph's nodes
graph \%>\% get_node_ids()

# Get the graph's edges
graph \%>\% get_edges()
}
\seealso{
Other Node creation and removal: 
\code{\link{add_n_node_clones}()},
\code{\link{add_n_nodes}()},
\code{\link{add_node_clones_ws}()},
\code{\link{add_node_df}()},
\code{\link{add_nodes_from_df_cols}()},
\code{\link{add_nodes_from_table}()},
\code{\link{add_node}()},
\code{\link{colorize_node_attrs}()},
\code{\link{copy_node_attrs}()},
\code{\link{create_node_df}()},
\code{\link{delete_nodes_ws}()},
\code{\link{delete_node}()},
\code{\link{drop_node_attrs}()},
\code{\link{join_node_attrs}()},
\code{\link{layout_nodes_w_string}()},
\code{\link{mutate_node_attrs_ws}()},
\code{\link{mutate_node_attrs}()},
\code{\link{node_data}()},
\code{\link{recode_node_attrs}()},
\code{\link{rename_node_attrs}()},
\code{\link{rescale_node_attrs}()},
\code{\link{set_node_attr_to_display}()},
\code{\link{set_node_attr_w_fcn}()},
\code{\link{set_node_attrs_ws}()},
\code{\link{set_node_attrs}()},
\code{\link{set_node_position}()}
}
\concept{Node creation and removal}
