% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{Vectorize.funD}
\alias{Vectorize.funD}
\title{Vectorize a multidimensional Function}
\usage{
Vectorize.funD(fund, d, .apply = base::apply)
}
\arguments{
\item{fund}{d-dimensional function to Vectorize}

\item{d}{dimension of input arguments of fund}

\item{.apply}{which vectorization to use (default is base::apply)}
}
\value{
a vectorized function (to be called on matrix argument, on each row)
}
\description{
Vectorize a d-dimensional (input) function, in the same way that base::Vectorize for 1-dimensional functions.
}
\examples{
f = function(x)x[1]+1; f(1:10); F = Vectorize.funD(f,1);
F(1:10); #F = Vectorize(f); F(1:10);

f2 = function(x)x[1]+x[2]; f2(1:10); F = Vectorize.funD(f2,2);
F(cbind(1:10,11:20)); #F = Vectorize(f); F(1:10);
}
