% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TempDisaggDGP.R
\name{TempDisaggDGP}
\alias{TempDisaggDGP}
\title{High and Low-Frequency Data Generating Processes}
\usage{
TempDisaggDGP(
  n_l,
  m,
  p = 1,
  beta = 1,
  sparsity = 1,
  method = "Denton-Cholette",
  aggMat = "sum",
  rho = 0,
  mean_X = 0,
  sd_X = 1,
  sd_e = 1,
  simul = FALSE,
  setSeed = 42
)
}
\arguments{
\item{n_l}{Size of the low frequency series.}

\item{m}{The integer multiple for generating the high-frequency series.}

\item{p}{The number of high-frequency indicator series to include.}

\item{beta}{The positive and negative beta elements for the coefficient vector.}

\item{sparsity}{Sparsity percentage of the coefficient vector.}

\item{method}{DGP according to 'Denton', 'Denton-Cholette', 'Chow-Lin', 'Fernandez', 'Litterman'.}

\item{aggMat}{Aggregation matrix according to 'first', 'sum', 'average', 'last'.}

\item{rho}{The residual autocorrelation coefficient. Default is 0.}

\item{mean_X}{Mean of the design matrix. Default is 0.}

\item{sd_X}{Standard deviation of the design matrix. Default is 1.}

\item{sd_e}{Standard deviation of the errors. Default is 1.}

\item{simul}{When 'TRUE' the design matrix and the coefficient vector are fixed.}

\item{setSeed}{The seed used when 'simul' is set to 'TRUE'.}
}
\value{
y_Gen	Generated high-frequency response series.

Y_Gen	Generated low-frequency response series.

X_Gen	Generated high-frequency indicator series.

Beta_Gen	Generated coefficient vector.

e_Gen	Generated high-frequency residual series.
}
\description{
This function generates the high-frequency \eqn{mn_l \times 1} response vector \eqn{y}, according to \eqn{y=X\beta+\epsilon}, where \eqn{X} is an \eqn{mn_l\times p} matrix of indicator
series, and the \eqn{mn_l\times 1} coefficient vector may be sparse. The low-frequency \eqn{n_l\times 1} vector \eqn{Y}
can be generated by pre-multiplying a disaggregation matrix \eqn{n_l\times mn_l} matrix, such that the sum, the average, the last or the first value of \eqn{y} equates the
corresponding \eqn{Y} observation. For a comprehensive review, see \insertCite{dagum2006benchmarking;textual}{DisaggregateTS}.
}
\examples{
data = TempDisaggDGP(n_l=50, m=4, p=4, method='Chow-Lin', rho=0.5)
X = data$X_Gen
Y = data$Y_Gen
}
\references{
\insertAllCited{}
}
\keyword{DGP}
\keyword{high-frequency}
\keyword{low-frequency}
\keyword{sparse}
