% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_speccomm.R
\name{generate_speccomm}
\alias{generate_speccomm}
\title{Generate Species Composition Matrix}
\usage{
generate_speccomm(spec_table_list)
}
\arguments{
\item{spec_table_list}{A list of species tables created by the generate_spec_tables function.}
}
\value{
A species composition matrix
}
\description{
Create a species composition matrix using a list of species tables.
}
\examples{
# create a SCM using a list of species counts tables
Colombia_Caquetá_dataframe <- subset(Colombia, stateProvince == "Caquetá")

Spec_Tables_Caquetá <- generate_spec_tables_df(

 dataframe = Colombia_Caquetá_dataframe,
 min_individuals = 30,
 min_species = 5

)

print(Spec_Tables_Caquetá$`2016-03-22`)
print(Spec_Tables_Caquetá$`2016-03-29`)
print(Spec_Tables_Caquetá$`2016-03-30`)
print(Spec_Tables_Caquetá$`2016-04-13`)

species_table_list <- list(

 Spec_Tables_Caquetá$`2016-03-22`,
 Spec_Tables_Caquetá$`2016-03-29`,
 Spec_Tables_Caquetá$`2016-03-30`,
 Spec_Tables_Caquetá$`2016-04-13`

)

SCM_Caquetá_2016 <- generate_speccomm(species_table_list)

print(SCM_Caquetá_2016)
}
