% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interaction_score.R
\name{calculate_interaction_score}
\alias{calculate_interaction_score}
\title{[INTERNAL] Calls a python script to calculate interaction score for combined graphs}
\usage{
calculate_interaction_score(
  max_path_length,
  total_edges,
  saving_path,
  conda = FALSE,
  python_executable = "python",
  script_path = NULL,
  int_score_mode = "auto",
  cluster_address = "auto",
  graphB_null = FALSE
)
}
\arguments{
\item{max_path_length}{[int] Integer of maximum length of simple paths to include in the
\code{\link[DrDimont]{generate_interaction_score_graphs}} computation. (default: 3)}

\item{total_edges}{Vector with total edges in each group}

\item{saving_path}{[string] Path to save intermediate output of DrDimont's functions.
Default is current working directory. Directory to use for writing intermediate data
when passing input and  output between Python and R.}

\item{conda}{[bool] Specifying if python is installed in a conda environment. Set TRUE if python is installed
with conda. Use \code{python_executable="-n name-of-your-environment python"} (change name-of-your-environment to
your environment) or \code{python_executable="python"} if installed in base environment. (default: FALSE)}

\item{python_executable}{[string] Path to Python executable used for generating the interaction score graphs.
(default: "python")}

\item{script_path}{[string] Path to the interaction score Python script. Set NULL to use package
internal script (default).}

\item{int_score_mode}{["auto"|"sequential"|"ray"] Whether to compute interaction
score in parallel using the Ray python library or sequentially. When `auto` it depends on the
graph sizes. (default: "auto")}

\item{cluster_address}{[string] Local node IP-address of Ray if executed on a cluster.
On a cluster: Start ray with \code{ray start --head --num-cpus 32} on the console before DrDimont execution.
It should work with "auto", if it does not specify IP-address given by the \code{ray start} command. (default: "auto")}

\item{graphB_null}{[bool] Specifying if graphB of `groupB` is given (FALSE) or not (TRUE). (default: FALSE)}
}
\value{
Does not return anything, instead calls Python script which outputs `gml` files
}
\description{
[INTERNAL] The interaction score is computed and saved in an additional `interaction_weight`
edge attribute. This function expects the combined graphs for both groups along with their corresponding drug
target and node lists to be saved at `saving_path`. Graphs and drug targets should be weighted edge lists
in `gml` and `tsv` format, respectively. Node files should contain one node id per line.
The script for calculating the interaction score is called with `python_executable`. An
alternate script can be specified with `script_path`.
The score for an edge is computed as the sum of the average product of weights along all simple
paths of length l (over all path lengths up to `max_path_length`) between the source and target node of the edge.
}
