% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline_functions.R
\name{compute_correlation_matrices}
\alias{compute_correlation_matrices}
\title{Computes correlation matrices for specified network layers}
\usage{
compute_correlation_matrices(layers, settings)
}
\arguments{
\item{layers}{[list] Named list with different network layers containing data and identifiers for both
groups (generated from \code{\link[DrDimont]{make_layer}})}

\item{settings}{[list] A named list containing pipeline settings. The settings list has to be
initialized by \code{\link[DrDimont]{drdimont_settings}}. Items in the named list can be
adjusted as desired.}
}
\value{
A nested named list with first-level elements `correlation_matrices` and `annotations`. The second
level elements are `groupA` and `groupB` (and `both` at `annotations`). These contain a named list of matrix
objects (`correlation_matrices`) and data frames (`annotations`) mapping the graph node IDs to biological
identifiers. The third level elements are the layer names given by the user.
}
\description{
Constructs and returns a correlation/adjacency matrices for each network layer
and each group. The adjacency matrix of correlations is computed using \link[WGCNA]{cor}.
The handling of missing data can be specified. Optionally, the adjacency matrices of the
correlations can be saved. Each node is mapped to the biological identifiers given in the
layers and the mapping table is returned as `annotations`.
}
\examples{
\dontshow{
WGCNA::disableWGCNAThreads()
}
data(layers_example)

example_settings <- drdimont_settings(
                       handling_missing_data=list(
                              default="pairwise.complete.obs",
                              mrna="all.obs"),
                       save_data=FALSE)

correlation_matrices <- compute_correlation_matrices(
                             layers=layers_example[c(1)], 
                             settings=example_settings)


}
