% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathway.analysis.R
\name{pathway.analysis}
\alias{pathway.analysis}
\title{Drug Mechanism of Action Pathway Analysis}
\usage{
pathway.analysis(drug.ident.res = drug.ident.res, pathway.list = NULL,
  pathway.list.path = NULL, drug.FDR.cutoff = 0.1, CEG.threshold = 0.05)
}
\arguments{
\item{drug.ident.res}{Dr. Insight drug identification analysis results. Output of function drug.ident().}

\item{pathway.list}{The pathways used to analyze drug mechanism. Should be a list of pathways where the names of lists are pathway names.
Dr.Insight provides NIH pathway interaction database (PID) pathways, which can be called by data("pathway.PID").
If you want to analyze with other pathways (from GSEA MsigDB), please use the parameter: pathway.list.path.}

\item{pathway.list.path}{The local path and file name of the pathways downloaded from GSEA MsigDB http://software.broadinstitute.org/gsea/msigdb/collections.jsp, if pathway.list is NULL.
Should be in full directory and file name (See instructions in vignette).}

\item{drug.FDR.cutoff}{The FDR threshold to select significant repurposed drugs by Dr. Insight for pathway analysis.}

\item{CEG.threshold}{The p value threhold for selecting significant consistently differential expressed genes (CEGs).}
}
\description{
This function allows user to run pathway analysis on the identified significat drugs, therefore to detect drug mechanism related pathways, and the CEGs in the pathways.
}
\examples{

## get the Dr. Insight drug identification results
drug.ident.res = drug.ident(query.data = example.disease, cmap.ref.profiles = example.drug.profiles,
                 repurposing.unit = "treatment", connectivity = "negative")

## load in example pathway data
data("example.pathway")

## Performe pathway analysis (for the drugs that are identified by ident.drug())
path.analysis.res = pathway.analysis(drug.ident.res = drug.ident.res,
                    pathway.list = example.pathway, drug.FDR.cutoff = 0.5)
}
\keyword{analysis}
\keyword{pathway}
