% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{tableDoseCoverage}
\alias{tableDoseCoverage}
\title{Format a dose_coverage object into a visual table.}
\usage{
tableDoseCoverage(
  result,
  header = c("variable_name", "estimate_name"),
  groupColumn = c("cdm_name", "ingredient_name"),
  type = "gt",
  hide = c("variable_level", "sample_size")
)
}
\arguments{
\item{result}{A summarised_result object.}

\item{header}{Columns to use as header. See options with
\code{availableTableColumns(result)}.}

\item{groupColumn}{Columns to group by. See options with
\code{availableTableColumns(result)}.}

\item{type}{Type of table. Check supported types with
\code{visOmopResults::tableType()}.}

\item{hide}{Columns to hide from the visualisation. See options with
\code{availableTableColumns(result)}.}
}
\value{
A table with a formatted version of summariseDrugCoverage() results.
}
\description{
Format a dose_coverage object into a visual table.
}
\examples{
\donttest{
cdm <- mockDrugUtilisation()

result <- summariseDoseCoverage(cdm, 1125315)

tableDoseCoverage(result)
}

}
