% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateAtcCohortSet.R
\name{generateAtcCohortSet}
\alias{generateAtcCohortSet}
\title{Generate a set of drug cohorts based on ATC classification}
\usage{
generateAtcCohortSet(
  cdm,
  name,
  atcName = NULL,
  gapEra = 1,
  subsetCohort = NULL,
  subsetCohortId = NULL,
  numberExposures = FALSE,
  daysPrescribed = FALSE,
  ...
)
}
\arguments{
\item{cdm}{A \code{cdm_reference} object.}

\item{name}{Name of the new cohort table, it must be a length 1 character
vector.}

\item{atcName}{Names of ATC classification of interest.}

\item{gapEra}{Number of days between two continuous exposures to be
considered in the same era. Records that have fewer days between them than
this gap will be concatenated into the same cohort record.}

\item{subsetCohort}{Cohort table to subset.}

\item{subsetCohortId}{Cohort id to subset.}

\item{numberExposures}{Whether to include 'number_exposures' (number of drug
exposure records between indexDate and censorDate).}

\item{daysPrescribed}{Whether to include 'days_prescribed' (number of days
prescribed used to create each era).}

\item{...}{Arguments to be passed to \code{CodelistGenerator::getATCCodes()}.}
}
\value{
The function returns the cdm reference provided with the addition of
the new cohort table.
}
\description{
Adds a new cohort table to the cdm reference with individuals who have drug
exposure records that belong to the specified Anatomical Therapeutic Chemical
(ATC) classification. Cohort start and end dates will be based on drug record
start and end dates, respectively. Records that overlap or have fewer days
between them than the specified gap era will be concatenated into a single
cohort entry.
}
\examples{
\donttest{
cdm <- mockDrugUtilisation()

cdm <- generateAtcCohortSet(
  cdm = cdm,
  atcName = "alimentary tract and metabolism",
  name = "drugs"
)

cdm$drugs |>
  dplyr::glimpse()
}
}
