% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addDrugUtilisation.R
\name{addDrugUtilisation}
\alias{addDrugUtilisation}
\title{Add new columns with drug use related information}
\usage{
addDrugUtilisation(
  cohort,
  gapEra,
  conceptSet = NULL,
  ingredientConceptId = NULL,
  indexDate = "cohort_start_date",
  censorDate = "cohort_end_date",
  restrictIncident = TRUE,
  numberExposures = TRUE,
  numberEras = TRUE,
  daysExposed = TRUE,
  daysPrescribed = TRUE,
  timeToExposure = TRUE,
  initialExposureDuration = TRUE,
  initialQuantity = TRUE,
  cumulativeQuantity = TRUE,
  initialDailyDose = TRUE,
  cumulativeDose = TRUE,
  nameStyle = "{value}_{concept_name}_{ingredient}",
  name = NULL
)
}
\arguments{
\item{cohort}{A cohort_table object.}

\item{gapEra}{Number of days between two continuous exposures to be
considered in the same era.}

\item{conceptSet}{List of concepts to be included.}

\item{ingredientConceptId}{Ingredient OMOP concept that we are interested for
the study.}

\item{indexDate}{Name of a column that indicates the date to start the
analysis.}

\item{censorDate}{Name of a column that indicates the date to stop the
analysis, if NULL end of individuals observation is used.}

\item{restrictIncident}{Whether to include only incident prescriptions in the
analysis. If FALSE all prescriptions that overlap with the study period will
be included.}

\item{numberExposures}{Whether to include 'number_exposures' (number of drug
exposure records between indexDate and censorDate).}

\item{numberEras}{Whether to include 'number_eras' (number of continuous
exposure episodes between indexDate and censorDate).}

\item{daysExposed}{Whether to include 'days_exposed' (number of days that the
individual is in a continuous exposure episode, including allowed treatment
gaps, between indexDate and censorDate; sum of the length of the different
drug eras).}

\item{daysPrescribed}{Whether to include 'days_prescribed' (sum of the number
of days for each prescription that contribute in the analysis).}

\item{timeToExposure}{Whether to include 'time_to_exposure' (number of days
between indexDate and the first episode).}

\item{initialExposureDuration}{Whether to include 'initial_exposure_duration'
(number of prescribed days of the first drug exposure record).}

\item{initialQuantity}{Whether to include 'initial_quantity' (quantity of the
first drug exposure record).}

\item{cumulativeQuantity}{Whether to include 'cumulative_quantity' (sum of
the quantity of the different exposures considered in the analysis).}

\item{initialDailyDose}{Whether to include 'initial_daily_dose_\{unit\}'
(daily dose of the first considered prescription).}

\item{cumulativeDose}{Whether to include 'cumulative_dose_\{unit\}' (sum of
the cumulative dose of the analysed drug exposure records).}

\item{nameStyle}{Character string to specify the nameStyle of the new columns.}

\item{name}{Name of the new computed cohort table, if NULL a temporary table
will be created.}
}
\value{
The same cohort with the added columns.
}
\description{
Add new columns with drug use related information
}
\examples{
\donttest{
library(DrugUtilisation)
library(CodelistGenerator)
library(dplyr, warn.conflicts = FALSE)

cdm <- mockDrugUtilisation()
codelist <- getDrugIngredientCodes(cdm = cdm, name = "acetaminophen")

cdm <- generateDrugUtilisationCohortSet(cdm = cdm,
                                        name = "dus_cohort",
                                        conceptSet = codelist)
cdm$dus_cohort |>
  addDrugUtilisation(ingredientConceptId = 1125315, gapEra = 30) |>
  glimpse()
}

}
