% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testFun.R
\name{testFun}
\alias{testFun}
\title{Test fun.density with lower and upper bounds}
\usage{
testFun(fun.density, lower, upper, args = list())
}
\arguments{
\item{fun.density}{A density function to be evaluated.}

\item{lower}{Lower bounds of the parameter space with which \code{fun.density} can be evaluated.}

\item{upper}{Upper bounds of the parameter space with which \code{fun.density} can be evaluated.}

\item{args}{Additional arguments for fun.density.}
}
\value{
Returns TRUE if no errors occured, otherwise returns an error message
}
\description{
Test fun.density with lower and upper bounds
}
\details{
A function that is called whenever a nondefault density function is passed to \code{DstarM}. It does some rough error checking.
}
\examples{
lower = c(.5, -6, .1, 0, 0)
upper = c(2, 6, .99, .99, 10)
args = list(t = seq(0, 5, .01), pars = lower, boundary = 'lower',
DstarM = TRUE)
testFun(fun.density = Voss.density, lower = lower, upper = upper,
args = args)
# TRUE
}

