% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtDescriptives.R
\name{rtDescriptives}
\alias{rtDescriptives}
\title{Descriptives of reaction time data}
\usage{
rtDescriptives(formula = NULL, data, plot = TRUE, verbose = TRUE)
}
\arguments{
\item{formula}{A formula object of the form: \code{binary response ~ reaction time + condition1 * condition2}}

\item{data}{A dataframe for looking up data specified in formula.
For backwards compatability this can also be with: a column named \code{rt} containing response times in ms,
a column named \code{response} containing at most 2 response options, and an
optional column named \code{condition} containing a numeric index as to which conditions
observations belong.}

\item{plot}{Logical, should a density plot of all condition-response pairs be made?}

\item{verbose}{Logical, should a table of counts and proportions be printed?}
}
\value{
Invisibly returns an object of class 'D*M'. It's first element is \code{table} and contains raw counts and proportions for
condition response pairs, conditions, and responses. It's second element \code{plot} contains a ggplot object.
}
\description{
Descriptives of reaction time data
}
\details{
This function and \code{\link{rtHist}} are helper functions to inspect raw data.
}
\examples{
tt <- seq(0, 5, .01)
pars <- matrix(.5, 5, 2)
pars[1, ] <- 1
pars[2, ] <- c(0, 2)
dat <- simData(n = 3e3, pars = pars, tt = tt, pdfND = dbeta(tt, 10, 30))
x <- rtDescriptives(data = dat)

print(x$table, what = 'cr')
print(x$table, what = 'c')
print(x$table, what = 'r')
}
