% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/A_OptimalInfo.R, R/E_class_IQLearnFS.R
\docType{methods}
\name{optTx}
\alias{optTx}
\alias{optTx,IQLearnFS,data.frame-method}
\alias{optTx,IQLearnFS,missing-method}
\title{Extract or Estimate the Optimal Tx and Decision Functions}
\usage{
optTx(x, newdata, ...)

\S4method{optTx}{IQLearnFS,data.frame}(x, newdata, ..., y = NULL,
  z = NULL, dens = NULL)

\S4method{optTx}{IQLearnFS,missing}(x, newdata, ..., y = NULL,
  z = NULL, dens = NULL)
}
\arguments{
\item{x}{a DynTxRegime Object.}

\item{newdata}{Optional data.frame if estimates for new patients are desired.}

\item{...}{Optional additional input.}

\item{y}{Object of class IQLearnFS}

\item{z}{Object of class IQLearnFS}

\item{dens}{one of \{norm, nonpar\}}
}
\description{
If newdata is provided, the results of the statistical method are used
  to estimate the decision functions and/or optimal tx. If
  newdata is missing, the estimated decision functions and/or optimal tx
  obtained for the original training data are returned.
}
\details{
Methods are defined for all statistical methods implemented in DynTxRegime.
}
