% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/E4.Diagnostics.Tempplot.R
\name{E4.Diagnostics.tempplot}
\alias{E4.Diagnostics.tempplot}
\title{Diagnostics: Plot Temperature data and button presses}
\usage{
E4.Diagnostics.tempplot(participant_list, rdslocation.binnedtemp,
  rdslocation.buttonpress, plotlocation.temp, Plot_E4s = TRUE,
  TempType = "C")
}
\arguments{
\item{participant_list}{list of participant numbers NOTE: This should match the names of the folders (e.g., participant 1001's data should be in a folder called "1001")}

\item{rdslocation.binnedtemp}{folder location where raw temperature data are stored}

\item{rdslocation.buttonpress}{location of folder where button press output is stored (from EDA part 2)}

\item{plotlocation.temp}{folder where you want PDF outputs to go.}

\item{Plot_E4s}{Do you want a line at the bottom of the plot showing which E4 the participant was wearing?}

\item{TempType}{Do you want Farenheit (TempType=F) or Celcius (TempType=C, default). If you did not elect to include Farenheit in the first temperature step, this step will calcuate it for you.}
}
\description{
This will allow you to see all binned temperature data for a participant, along with which band they were wearing and when they pressed the event marker. One PDF file is made per participant. You must run E4.extras.BinEDA() first to prepare for this step.
}
\examples{
\dontrun{E4.Diagnostics.EDAplot(participant_list=c(1001:1004),
rdslocation.buttonpress="~/study/data/tags/",
rdslocation.binnedtemp="~/study/data/Binned_EDA/",
plotlocation.EDA="~/study/data/EDAplots/")}




}
\keyword{diagnostics}
\keyword{plots}
