% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateScore.R
\name{generateScore}
\alias{generateScore}
\title{Calculate the polygenic risk scores}
\usage{
generateScore(sigmaHat2, muHat, X)
}
\arguments{
\item{sigmaHat2}{parameters generated by 'findPara', estimated variations}

\item{muHat}{parameters generated by 'findPara', estimated effect sizes}

\item{X}{bed file}
}
\value{
Polygenic risk scores for each individual calculated by the EBPRS model (S).
}
\description{
Function that generates PRS for each individual.
}
\examples{
S <- generateScore(sigmaHat2=rep(1,100),muHat=rep(0.1,100),
X=matrix(sample(0:1,size=1000,replace=TRUE),10,100) )
}
\references{
Song, S., Jiang, W., Hou, L. and Zhao, H. Leveraging effect size distributions to improve polygenic risk scores derived from genome-wide association studies. \emph{Submitted}.
}
\seealso{
\code{\link{extractInfo}}

\code{\link{findPara}}
}
\author{
Shuang Song, Wei Jiang, Lin Hou and Hongyu Zhao
}
