% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/online.r
\name{websearch_ecotox}
\alias{websearch_ecotox}
\alias{list_ecotox_web_fields}
\title{Search and retrieve toxicity records from the on-line database}
\usage{
websearch_ecotox(
  fields = list_ecotox_web_fields(),
  habitat = c("aquire", "terrestrial"),
  ...
)

list_ecotox_web_fields(...)
}
\arguments{
\item{fields}{A named \code{list} of \code{character}s, used to build a search for for the on-line search query of
\url{https://cfpub.epa.gov/ecotox/search.cfm}.
Use \code{\link[=list_ecotox_web_fields]{list_ecotox_web_fields()}} to construct a valid list.}

\item{habitat}{Use \code{aquire} (default) to retrieve aquatic data, \code{terrestrial} for, you've guessed it, terrestrial data.}

\item{...}{In case of \code{\link[=list_ecotox_web_fields]{list_ecotox_web_fields()}} the dots can be used as search field values used to update the returned list of fields.

In case of \code{\link[=websearch_ecotox]{websearch_ecotox()}} the dots can be used to pass custom options to the underlying \code{\link[httr:POST]{httr::POST()}} call. For available
field names, use \code{names(list_ecotox_web_fields())}}
}
\value{
Returns named \code{list} of \link[dplyr:reexports]{dplyr::tibble}s with search results. Results are unpolished and `as is' returned by EPA's web service.

\code{\link[=list_ecotox_web_fields]{list_ecotox_web_fields()}} returns a named list with fields that can be used in a web search of EPA's ECOTOX database, using
\code{\link[=websearch_ecotox]{websearch_ecotox()}}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Functions to search and retrieve records from the on-line database at
\url{https://cfpub.epa.gov/ecotox/search.cfm}.
}
\details{
The functions described here to search and retrieve records from the on-line database are experimental. This is because this feature is
not formally supported by the EPA, and it may break in future iterations of the on-line database. The functions form an interface between
R and the ECOTOX website and is therefore limited by its restrictions as described in the package documentation: \link{ECOTOXr}. The
functions should therefore be used with caution.
}
\note{
\strong{IMPORTANT:} when you plan to perform multiple adjacent searches (for instance in a loop), please insert a call to \code{\link[=Sys.sleep]{Sys.sleep()}}.
This to avoid overloading the server and getting your IP address banned from the server.
}
\examples{
\dontrun{
search_fields <-
  list_ecotox_web_fields(
    txAdvancedSpecEntries     = "daphnia magna",
    RBSPECSEARCHTYPE          = "EXACT",
    txAdvancedChemicalEntries = "benzene",
    RBCHEMSEARCHTYPE          = "EXACT")
search_results <- websearch_ecotox(search_fields)
}
}
\seealso{
Other search-functions: 
\code{\link{search_ecotox}()},
\code{\link{websearch_comptox}()}
}
\author{
Pepijn de Vries
}
\concept{online-search-functions}
\concept{search-functions}
