% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linearity.R
\name{linearity.class}
\alias{linearity.class}
\alias{linearity.class.default}
\alias{linearity.class.formula}
\title{Measures of linearity}
\usage{
linearity.class(...)

\method{linearity.class}{default}(x, y, measures = "all", ...)

\method{linearity.class}{formula}(formula, data, measures = "all", ...)
}
\arguments{
\item{...}{Not used.}

\item{x}{A data.frame contained only the input attributes.}

\item{y}{A factor response vector with one label for each row/component of x.}

\item{measures}{A list of measures names or \code{"all"} to include all them.}

\item{formula}{A formula to define the class column.}

\item{data}{A data.frame dataset contained the input attributes and class.}
}
\value{
A list named by the requested linearity measure.
}
\description{
Classification task. The linearity measures try to quantify if it is possible
to separate the classes by a hyperplane. The underlying assumption is that a 
linearly separable problem can be considered simpler than a problem requiring
a non-linear decision boundary.
}
\details{
The following measures are allowed for this method:
 \describe{
   \item{"L1"}{Sum of the error distance by linear programming (L1) computes 
     the sum of the distances of incorrectly classified examples to a linear 
     boundary used in their classification.}
   \item{"L2"}{Error rate of linear classifier (L2) computes the error rate 
     of the linear SVM classifier induced from dataset.}
   \item{"L3"}{Non-linearity of a linear classifier (L3) creates a new 
     dataset randomly interpolating pairs of training examples of the same 
     class and then induce a linear SVM on the original data and measure 
     the error rate in the new data points.}
 }
}
\examples{
## Extract all linearity measures
data(iris)
linearity.class(Species ~ ., iris)
}
\references{
Albert Orriols-Puig, Nuria Macia and Tin K Ho. (2010). Documentation for the
   data complexity library in C++. Technical Report. La Salle - Universitat 
   Ramon Llull.
}
\seealso{
Other complexity-measures: \code{\link{balance}},
  \code{\link{correlation}}, \code{\link{dimensionality}},
  \code{\link{linearity.regr}}, \code{\link{neighborhood}},
  \code{\link{network}}, \code{\link{overlapping}},
  \code{\link{smoothness}}
}
\concept{complexity-measures}
