% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linearity.R
\name{linearity.regr}
\alias{linearity.regr}
\alias{linearity.regr.default}
\alias{linearity.regr.formula}
\title{Measures of linearity}
\usage{
linearity.regr(...)

\method{linearity.regr}{default}(x, y, measures = "all", ...)

\method{linearity.regr}{formula}(formula, data, measures = "all", ...)
}
\arguments{
\item{...}{Not used.}

\item{x}{A data.frame contained only the input attributes.}

\item{y}{A response vector with one value for each row/component of x.}

\item{measures}{A list of measures names or \code{"all"} to include all them.}

\item{formula}{A formula to define the output column.}

\item{data}{A data.frame dataset contained the input and output attributes.}
}
\value{
A list named by the requested linearity measure.
}
\description{
Regression task. These measures capture whether a linear function provides a 
good fit to the problem. If this is the case, the problem can be considered 
simpler than one in which a non-linear function is required.
}
\details{
The following measures are allowed for this method:
 \describe{
   \item{"L1"}{Mean absolute error (L1) averages the absolute values of the 
     residues of a multiple linear regressor.}
   \item{"L2"}{Residuals variance (L2) averages the square of the residuals 
     from a multiple linear regression.}
   \item{"L3"}{Non-linearity of a linear regressor (L3) measures how 
     sensitive the regressor is to the new randomly interpolated points.}
 }
}
\examples{
## Extract all regression linearity measures
data(cars)
linearity.regr(speed~., cars)
}
\references{
Ana C Lorena and Aron I Maciel and Pericles B C Miranda and Ivan G Costa and
   Ricardo B C Prudencio. (2018). Data complexity meta-features for 
   regression problems. Machine Learning, 107, 1, 209--246.
}
\seealso{
Other complexity-measures: \code{\link{balance}},
  \code{\link{correlation}}, \code{\link{dimensionality}},
  \code{\link{linearity.class}},
  \code{\link{neighborhood}}, \code{\link{network}},
  \code{\link{overlapping}}, \code{\link{smoothness}}
}
\concept{complexity-measures}
