% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate.sample.R
\name{estimate}
\alias{estimate}
\alias{estimate.uniform}
\alias{estimate.normal}
\alias{estimate.gamma}
\alias{estimate.logistic}
\alias{estimate.laplace}
\alias{estimate.weibull}
\alias{estimate.exp}
\title{MLE for univariate sample}
\usage{
estimate.uniform(x)

estimate.normal(x)

estimate.gamma(x, use.rate = FALSE)

estimate.logistic(x, eps = 1e-07, verbose = FALSE)

estimate.laplace(x, use.sd = FALSE)

estimate.weibull(x, eps = 1e-07)

estimate.exp(x, use.rate = FALSE)
}
\arguments{
\item{x}{A random sample.}

\item{use.rate}{Logical; if TRUE use the rate instead of the scale.}

\item{eps}{Stopping criterion, 1e-7 by default.}

\item{verbose}{Logical; if TRUE, print estimates in each iteration.}

\item{use.sd}{Logical; if TRUE use the sd instead of the scale for Laplace distribution.}
}
\value{
Estimated parameters of the assumed distribution by MLE.
}
\description{
Estimate parameters of various distributions by the method of maximum likelihood.
The following families are available: Normal(location=\eqn{\mu},scale=\eqn{\sigma^2}),
Gamma(shape=\eqn{\alpha},scale=\eqn{\beta}), Logistic(location=\eqn{\mu},scale=s),
Laplace(location=\eqn{\mu},scale=b), Weibull(shape=\eqn{\alpha},scale=\eqn{\beta}),
and Exponential(scale=\eqn{\theta}).
}
\examples{
x0=runif(n=100,min=-1,max=1)
estimate.uniform(x0)

x1=rnorm(n=100,mean=0,sd=1)
estimate.normal(x1)

x2=rgamma(n=100,shape=1,scale=1)
estimate.gamma(x2)

x3=rlogis(n=100,location=0,scale=1)
estimate.logistic(x3)

x4= rmutil::rlaplace(n=100,m=0,s=1)
estimate.laplace(x4)

x5=rweibull(n=100,shape=1,scale=1)
estimate.weibull(x5)

x6=rexp(n=100,rate=1/2)
estimate.exp(x6,use.rate=TRUE)
}
