% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EEAaq_time_aggregate.R
\name{EEAaq_time_aggregate}
\alias{EEAaq_time_aggregate}
\title{Time aggregation of an \code{EEAaq_df} class object.}
\usage{
EEAaq_time_aggregate(
  data = NULL,
  frequency = "monthly",
  aggr_fun = c("mean", "min", "max")
)
}
\arguments{
\item{data}{an \code{EEAaq_df} or \code{EEAaq_df_sfc} class object, which is the output of the \code{\link{EEAaq_get_data}} function.}

\item{frequency}{vector containing the time frequency for which to aggregate the \code{data} object.
Admissible values are 'yearly', 'monthly', 'weekly', 'daily' 'hourly'.}

\item{aggr_fun}{character vector containing one or more agregation functions. Admissible values are 'mean', 'median',
'min', 'max', 'sd', 'var', 'kurtosis', 'skewness',
'quantile_pp' (where pp is a number in the range [0,1], representing the required percentile).}
}
\value{
A \code{EEAaq_taggr_df} or a \code{EEAaq_taggr_df_sfc} class object, which is a tibble containing the
required time aggregation.
}
\description{
\code{EEAaq_time_aggregate} compute a time aggregation of an \code{EEAaq_df} or \code{EEAaq_df_sfc} class object,
based on the specified \code{frequency} and the aggregation functions \code{aggr_fun}.
}
\examples{
\donttest{
data <- EEAaq_get_data(zone_name = "Milano", NUTS_level = "LAU",
  pollutant = "PM10", from = 2023, to = 2023, ID = FALSE, verbose = TRUE)
EEAaq_time_aggregate(data = data, frequency = "monthly", aggr_fun = c("mean", "min", "max"))
EEAaq_time_aggregate(data = data, frequency = "yearly", aggr_fun = "mean")
}
}
