% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EEAaq_map_stations.R
\name{EEAaq_map_stations}
\alias{EEAaq_map_stations}
\title{Create a map representing the stations based on the data given in input or
the information specified in the parameters}
\usage{
EEAaq_map_stations(
  data = NULL,
  pollutant = NULL,
  zone_name = NULL,
  NUTS_level = NULL,
  ID = FALSE,
  bounds_level = NULL,
  color = TRUE,
  dynamic = FALSE
)
}
\arguments{
\item{data}{an \code{EEAaq_df} or \code{EEAaq_df_sfc} class object, which is the output of the \code{\link{EEAaq_get_data}} function.}

\item{pollutant}{character vector containing the short names of the pollutants for which locate the stations.}

\item{zone_name}{character vector specifying the names of the zones to consider.
The reference is the NUTS and LAU nomnclature by Eurostat.}

\item{NUTS_level}{chracter that specify the level of NUTS or LAU, to which the \code{zone_name} belongs.}

\item{ID}{logic value (T or F). If \code{TRUE} the character specified in the parameter
zone_name is the unique identifier code provided by Eurostat. If \code{FALSE} (the default) it indicates that
was specified the full name in latin characters.}

\item{bounds_level}{character containing the NUTS level or LAU for which draw internal boundaries.
Admissible values are "NUTS0", "NUTS1", "NUTS2", "NUTS3", "LAU" and it must be of a lower level then
the one specified in the parameter \code{NUTS_level}.}

\item{color}{logical value (T or F). If \code{TRUE} (the default) the points are colored based on the pollutant they are
able to detect. If \code{FALSE} the points have the same color.}

\item{dynamic}{logical value (T or F). If \code{TRUE} the map is interactive and dynamic. If \code{FALSE} (the default) the map is static.}
}
\value{
A map representing the specified area and the points representing the location of the stations able to detect
the specified pollutants.
}
\description{
Build static or dynamic maps, representing the location of the stations that detects the specified pollutants.
It recieves in input an \code{EEAaq_df} or an \code{EEAaq_df_sfc} class object, or, alternatively, it's possible to specify
the required zones and pollutants with the same nomenclature system of the \code{\link{EEAaq_get_data}} function.
}
\examples{
\donttest{
# Using as example PM data in Lombardia (Italy) during the whole 2022,
# it's possible to map the stations in two ways.
# First of all specifying the zone information:
EEAaq_map_stations(pollutant = c("PM10", "PM2.5"),
zone_name = "Lombardia",NUTS_level = "NUTS2", ID = FALSE, color = FALSE)
#In this case each point have the same color.

# Alternatively, it is possible to use the data already downloaded in the parameter data,
# coloring the points based on the pollutants the respective station detects.
data <- EEAaq_get_data(zone_name = "15146", NUTS_level = "LAU",LAU_ISO = "IT",
pollutants = "PM10", from = "2023-01-01", to = "2023-05-31",  verbose = TRUE)
EEAaq_map_stations(data = data, color = TRUE)
}

}
