#' Woodcock Johnson IV: ages 20 to 39
#'
#' A list containing the bivariate correlations (N = 1,251) of the 47
#' intelligence subtests from the WJ IV for 20- to 39-year-olds obtained from
#' the WJ-IV technical manual (McGrew, LaForte, & Schrank, 2014).
#' Tables are reproduced with permission from the publisher.
#'
#'
#' @format A list of 2 with elements "cormat" (47 x 47 matrix of bivariate correlations)
#' and "N" (scalar). The correlation matrix contains the following variables:
#' \describe{
#'   \item{ORLVOC}{(numeric) - Oral Vocabulary.}
#'   \item{NUMSER}{(numeric) - Number Series.}
#'   \item{VRBATN}{(numeric) - Verbal Attention.}
#'   \item{LETPAT}{(numeric) - Letter-Pattern Matching.}
#'   \item{PHNPRO}{(numeric) - Phonological Processing.}
#'   \item{STYREC}{(numeric) - Story Recall.}
#'   \item{VISUAL}{(numeric) - Visualization.}
#'   \item{GENINF}{(numeric) - General Information.}
#'   \item{CONFRM}{(numeric) - Concept Formation.}
#'   \item{NUMREV}{(numeric) - Numbers Reversed.}
#'   \item{NUMPAT}{(numeric) - Number-Pattern Matching.}
#'   \item{NWDREP}{(numeric) - Nonword Repetition.}
#'   \item{VAL}{(numeric) - Visual-Auditory Learning.}
#'   \item{PICREC}{(numeric) - Picture Recognition.}
#'   \item{ANLSYN}{(numeric) - Analysis-Synthesis.}
#'   \item{OBJNUM}{(numeric) - Object-Number Sequencing.}
#'   \item{PAIRCN}{(numeric) - Pair Cancellation.}
#'   \item{MEMWRD}{(numeric) - Memory for Words.}
#'   \item{PICVOC}{(numeric) - Picture Vocabulary.}
#'   \item{ORLCMP}{(numeric) - Oral Comprehension.}
#'   \item{SEGMNT}{(numeric) - Segmentation.}
#'   \item{RPCNAM}{(numeric) - Rapid Picture Naming.}
#'   \item{SENREP}{(numeric) - Sentence Repetition.}
#'   \item{UNDDIR}{(numeric) - Understanding Directions.}
#'   \item{SNDBLN}{(numeric) - Sound Blending.}
#'   \item{RETFLU}{(numeric) - Retrieval Fluency.}
#'   \item{SNDAWR}{(numeric) - Sound Awareness.}
#'   \item{LWIDNT}{(numeric) - Letter-Word Identification.}
#'   \item{APPROB}{(numeric) - Applied Problems.}
#'   \item{SPELL}{(numeric) - Spelling.}
#'   \item{PSGCMP}{(numeric) - Passage Comprehension.}
#'   \item{CALC}{(numeric) - Calculation.}
#'   \item{WRTSMP}{(numeric) - Writing Samples.}
#'   \item{WRDATK}{(numeric) - Word Attack.}
#'   \item{ORLRDG}{(numeric) - Oral Reading.}
#'   \item{SNRDFL}{(numeric) - Sentence Reading Fluency.}
#'   \item{MTHFLU}{(numeric) - Math Facts Fluency.}
#'   \item{SNWRFL}{(numeric) - Sentence Writing Fluency.}
#'   \item{RDGREC}{(numeric) - Reading Recall.}
#'   \item{NUMMAT}{(numeric) - Number Matrices.}
#'   \item{EDIT}{(numeric) - Editing.}
#'   \item{WRDFLU}{(numeric) - Word Reading Fluency.}
#'   \item{SPLSND}{(numeric) - Spelling of Sounds.}
#'   \item{RDGVOC}{(numeric) - Reading Vocabulary.}
#'   \item{SCI}{(numeric) - Science.}
#'   \item{SOC}{(numeric) - Social Studies.}
#'   \item{HUM}{(numeric) - Humanities.}
#'  }
#' @source McGrew, K. S., LaForte, E. M., & Schrank, F. A. (2014). Technical
#'  Manual. Woodcock-Johnson IV. Rolling Meadows, IL: Riverside.
#'
#' @source Schrank, F. A., McGrew, K. S., & Mather, N. (2014). Woodcock-Johnson IV.
#' Rolling Meadows, IL: Riverside.
"WJIV_ages_20_39"
