% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BARTLETT.R
\name{BARTLETT}
\alias{BARTLETT}
\title{Bartlett's test of sphericity}
\source{
Bartlett, M. S. (1951). The effect of standardization on a Chi-square
approximation in factor analysis. Biometrika, 38, 337-344.
}
\usage{
BARTLETT(
  x,
  N = NA,
  use = c("pairwise.complete.obs", "all.obs", "complete.obs", "everything",
    "na.or.complete"),
  cor_method = c("pearson", "spearman", "kendall")
)
}
\arguments{
\item{x}{data.frame or matrix. Dataframe or matrix of raw data or matrix with
correlations.}

\item{N}{numeric. The number of observations. Needs only be specified if a
correlation matrix is used.}

\item{use}{character. Passed to \code{\link[stats:cor]{stats::cor}} if raw data
is given as input. Default is "pairwise.complete.obs".}

\item{cor_method}{character. Passed to \code{\link[stats:cor]{stats::cor}}.
Default is "pearson".}
}
\value{
A list containing
\item{chisq}{The chi square statistic.}
\item{p_value}{The p value of the chi square statistic.}
\item{df}{The degrees of freedom for the chi square statistic.}
\item{settings}{A list of the settings used.}
}
\description{
This function tests whether a correlation matrix is significantly different
from an identity matrix (Bartlett, 1951). If the Bartlett's test is not
significant, the correlation matrix is not suitable for factor analysis
because the variables show too little covariance.
}
\details{
Bartlett (1951) proposed this statistic to determine a correlation
matrix' suitability for factor analysis. The statistic is approximately
chi square distributed with \eqn{df = \frac{p(p - 1)}{2}} and is given by

\deqn{chi^2 = -log(det(R)) (N - 1 - (2 * p + 5)/6)}

where \eqn{det(R)} is the determinant of the correlation matrix, \eqn{N} is
the sample size, and \eqn{p} is the number of variables.

This tests requires multivariate normality. If this condition is not met,
the Kaiser-Meyer-Olkin criterion (\code{\link[EFAtools]{KMO}})
can still be used.

This function was heavily influenced by the \code{\link[psych:cortest.bartlett]{psych::cortest.bartlett}} function from the psych package.

The \code{BARTLETT} function can also be called together with the
 (\code{\link[EFAtools]{KMO}}) function and with factor retention criteria
 in the \code{\link{N_FACTORS}} function.
}
\examples{
BARTLETT(test_models$baseline$cormat, N = 500)

}
\seealso{
\code{\link[EFAtools]{KMO}} for another measure to determine
 suitability for factor analysis.

 \code{\link{N_FACTORS}} as a wrapper function for this function,
 \code{\link[EFAtools]{KMO}} and several factor retention criteria.
}
