% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EKC.R
\name{EKC}
\alias{EKC}
\title{Empirical Kaiser Criterion}
\source{
Auerswald, M., & Moshagen, M. (2019). How to determine the number of
factors to retain in exploratory factor analysis: A comparison of extraction
methods under realistic conditions. Psychological Methods, 24(4), 468–491.
https://doi.org/10.1037/met0000200

Braeken, J., & van Assen, M. A. (2017). An empirical Kaiser criterion.
Psychological Methods, 22, 450 – 466. http://dx.doi.org/10.1037/ met0000074

Zwick, W. R., & Velicer, W. F. (1986). Comparison of five rules for
determining the number of components to retain. Psychological Bulletin, 99,
432–442. http://dx.doi.org/10.1037/0033-2909.99.3.432
}
\usage{
EKC(
  x,
  N = NA,
  use = c("pairwise.complete.obs", "all.obs", "complete.obs", "everything",
    "na.or.complete"),
  cor_method = c("pearson", "spearman", "kendall")
)
}
\arguments{
\item{x}{data.frame or matrix. data.frame or matrix of raw data or matrix with
correlations.}

\item{N}{numeric. The number of observations. Only needed if x is a correlation
matrix.}

\item{use}{character. Passed to \code{\link[stats:cor]{stats::cor}} if raw
data is given as input. Default is  \code{"pairwise.complete.obs"}.}

\item{cor_method}{character. Passed to \code{\link[stats:cor]{stats::cor}}.
Default is  \code{"pearson"}.}
}
\value{
A list of class EKC containing

\item{eigenvalues}{A vector containing the eigenvalues found on the correlation matrix of the entered data.}
\item{n_factors}{The number of factors to retain according to the empirical Kaiser criterion.}
\item{references}{The reference eigenvalues.}
\item{settings}{A list with the settings used.}
}
\description{
The empirical Kaiser criterion incorporates random sampling variations of the
eigenvalues from the Kaiser-Guttman criterion (\code{\link{KGC}}; see Auerswald & Moshagen
, 2019; Braeken & van Assen, 2017). The code is based on Auerswald and Moshagen
(2019).
}
\details{
The Kaiser-Guttman criterion was defined with the intend that a factor
 should only be extracted if it explains at least as much variance as a single
 factor (see \code{\link{KGC}}). However, this only applies to population-level
 correlation matrices. Due to sampling variation, the KGC strongly overestimates
 the number of factors to retrieve (e.g., Zwick & Velicer, 1986). To account
 for this and to introduce a factor retention method that performs well with
 small number of indicators and correlated factors (cases where the performance
 of parallel analysis, see \code{\link{PARALLEL}}, is known to deteriorate)
 Braeken and van Assen (2017) introduced the empirical Kaiser criterion in
 which a series of reference eigenvalues is created as a function of the
 variables-to-sample-size ratio and the observed eigenvalues.

 Braeken and van Assen (2017) showed that "(a) EKC performs about as well as
 parallel analysis for data arising from the null, 1-factor, or orthogonal
 factors model; and (b) clearly outperforms parallel analysis for the specific
 case of oblique factors, particularly whenever factor intercorrelation is
 moderate to high and the number of variables per factor is small, which is
 characteristic of many applications these days" (p.463-464).

 The \code{EKC} function can also be called together with other factor
  retention criteria in the \code{\link{N_FACTORS}} function.
}
\examples{
EKC(test_models$baseline$cormat, N = 500)
}
\seealso{
Other factor retention criteria: \code{\link{CD}},
 \code{\link{HULL}}, \code{\link{KGC}}, \code{\link{PARALLEL}},
 \code{\link{SMT}}

  \code{\link{N_FACTORS}} as a wrapper function for this and all
  the above-mentioned factor retention criteria.
}
