% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EFDR_functions.R
\name{test_image}
\alias{test_image}
\title{Create a test image}
\usage{
test_image(h = 1, r = 10, n1 = 64, n2 = 64)
}
\arguments{
\item{h}{amplitude of the filled circle}

\item{r}{radius of the circle (in pixels)}

\item{n1}{image height in pixels}

\item{n2}{image width in pixels}
}
\value{
List with two elements
\describe{
\item{\code{z}}{the test image}
\item{\code{signal.grid}}{the x-y grid in long table format} 
}
}
\description{
This function generates an image for test purposes. The image is that of a filled circle
at the centre.
}
\examples{
Z <- test_image()$z
}
\references{
Shen, X., Huang, H.-C., and Cressie, N. 'Nonparametric hypothesis testing for a spatial signal.' Journal of the American Statistical Association 97.460 (2002): 1122-1140.
}
